/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.transform.migrate;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import znaishaded.com.fasterxml.jackson.core.type.TypeReference;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jackson.JsonLoader;
import znaishaded.com.github.fge.jsonpatch.JsonPatch;
import znaishaded.com.github.fge.jsonpatch.JsonPatchException;
import znaishaded.com.google.common.base.Optional;
import znaishaded.io.swagger.transform.migrate.SwaggerMigrator;
import znaishaded.io.swagger.transform.util.SwaggerMigrationException;
import znaishaded.io.swagger.transform.util.SwaggerMigrators;

public final class V11TypeMigrator
implements SwaggerMigrator {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final TypeReference<Map<String, JsonPatch>> TYPE_REF = new TypeReference<Map<String, JsonPatch>>(){};
    private static final JsonPatch DEFAULT_PATCH;
    private final Map<String, JsonPatch> patches;
    private final JsonPatch fileTypePatch;

    public V11TypeMigrator() {
        try {
            JsonNode node = JsonLoader.fromResource("/patches/v1.1/dataType.json");
            this.patches = MAPPER.readValue(node.traverse(), TYPE_REF);
            node = JsonLoader.fromResource("/patches/other/fileTypePatch.json");
            this.fileTypePatch = MAPPER.readValue(node.traverse(), JsonPatch.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load the necessary file", e);
        }
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        JsonNode node = input.path("dataType");
        if (node.isMissingNode()) {
            return this.postMigrate(input);
        }
        if (!node.isTextual()) {
            throw new SwaggerMigrationException("dataType is not a text field");
        }
        String dataType = node.textValue();
        JsonPatch patch = Optional.fromNullable(this.patches.get(dataType)).or(DEFAULT_PATCH);
        JsonNode migrated = SwaggerMigrators.fromPatch(patch).migrate(input);
        return this.postMigrate(migrated);
    }

    private JsonNode postMigrate(JsonNode input) throws SwaggerMigrationException {
        JsonNode typeNode = input.path("type");
        if (!typeNode.isTextual()) {
            return input;
        }
        if (!"File".equals(typeNode.textValue())) {
            return input;
        }
        try {
            return this.fileTypePatch.apply(input);
        }
        catch (JsonPatchException e) {
            throw new SwaggerMigrationException(e);
        }
    }

    static {
        String op = "[{\"op\":\"move\",\"from\":\"/dataType\",\"path\":\"/$ref\"}]";
        try {
            DEFAULT_PATCH = MAPPER.readValue("[{\"op\":\"move\",\"from\":\"/dataType\",\"path\":\"/$ref\"}]", JsonPatch.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

