/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.eventbus.impl.codecs;

import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.eventbus.MessageCodec;
import znaishaded.io.vertx.core.json.JsonArray;

public class JsonArrayMessageCodec
implements MessageCodec<JsonArray, JsonArray> {
    @Override
    public void encodeToWire(Buffer buffer, JsonArray jsonArray) {
        Buffer encoded = jsonArray.toBuffer();
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
    }

    @Override
    public JsonArray decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        return new JsonArray(buffer.slice(pos += 4, pos + length));
    }

    @Override
    public JsonArray transform(JsonArray jsonArray) {
        return jsonArray.copy();
    }

    @Override
    public String name() {
        return "jsonarray";
    }

    @Override
    public byte systemCodecID() {
        return 14;
    }
}

