/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.SName;

class USymbolLabel
extends USymbol {
    USymbolLabel() {
    }

    @Override
    public SName getSName() {
        return SName.label;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbol.Margin margin = USymbolLabel.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolLabel.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, final HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                ug = symbolContext.apply(ug);
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolLabel.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolLabel.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = labelAlignment == HorizontalAlignment.LEFT ? 3.0 : (labelAlignment == HorizontalAlignment.RIGHT ? width - dimTitle.getWidth() - 3.0 : (width - dimTitle.getWidth()) / 2.0);
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

