/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleMath
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<math\\>(.+?)\\</math\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleMath() {
    }

    public static Command create() {
        return new CommandCreoleMath();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String math = m3.group(2);
        stripe.addMath(ScientificEquationSafe.fromAsciiMath(math));
        return line.substring(m3.group(1).length());
    }
}

