/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.klimt.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.klimt.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomTable;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomWithMargin;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.CreoleParser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.text.BackSlash;

public class StripeTable
implements Stripe {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTable table;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    private static final String hiddenBar = "\ue000";

    public StripeTable(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.skinParam = skinParam;
        this.fontConfiguration = fontConfiguration;
        HColor lineColor = this.getBackOrFrontColor(line, 1);
        if (lineColor == null) {
            lineColor = fontConfiguration.getColor();
        }
        this.table = new AtomTable(lineColor);
        this.marged = new AtomWithMargin(this.table, 2.0, 2.0);
        this.analyzeAndAddInternal(line);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    static Atom asAtom(List<StripeSimple> cells, double padding) {
        Sheet sheet = new Sheet(HorizontalAlignment.LEFT);
        for (StripeSimple cell : cells) {
            sheet.add(cell);
        }
        return new SheetBlock1(sheet, LineBreakStrategy.NONE, padding);
    }

    private HColor getBackOrFrontColor(String line, int idx) {
        if (CreoleParser.doesStartByColor(line)) {
            int idx1 = line.indexOf(35);
            int idx2 = line.indexOf(62);
            if (idx2 == -1) {
                throw new IllegalStateException();
            }
            String[] color = line.substring(idx1, idx2).split(",");
            if (idx < color.length) {
                String s2 = color[idx];
                return s2 == null ? null : this.skinParam.getIHtmlColorSet().getColorOrWhite(s2);
            }
        }
        return null;
    }

    private String withouBackColor(String line) {
        int idx2 = line.indexOf(62);
        if (idx2 == -1) {
            throw new IllegalStateException();
        }
        return line.substring(idx2 + 1);
    }

    private void analyzeAndAddInternal(String line) {
        HColor lineBackColor = this.getBackOrFrontColor(line = line.replace("\\|", hiddenBar), 0);
        if (lineBackColor != null) {
            line = this.withouBackColor(line);
        }
        this.table.newLine(lineBackColor);
        StringTokenizer st = new StringTokenizer(line, "|");
        while (st.hasMoreTokens()) {
            HColor cellBackColor;
            Mode mode = Mode.NORMAL;
            String v = st.nextToken().replace(hiddenBar.charAt(0), '|');
            if (v.startsWith("=")) {
                v = v.substring(1);
                mode = Mode.HEADER;
            }
            if ((cellBackColor = this.getBackOrFrontColor(v, 0)) != null) {
                v = this.withouBackColor(v);
            }
            List<String> lines = StripeTable.getWithNewlinesInternal(v);
            ArrayList<StripeSimple> cells = new ArrayList<StripeSimple>();
            for (String s2 : lines) {
                StripeSimple cell = new StripeSimple(this.getFontConfiguration(mode), this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
                if (s2.startsWith("<r>")) {
                    cell.setCellAlignment(HorizontalAlignment.RIGHT);
                    s2 = s2.substring("<r>".length());
                }
                cell.analyzeAndAdd(s2);
                cells.add(cell);
            }
            this.table.addCell(StripeTable.asAtom(cells, this.skinParam.getPadding()), cellBackColor);
        }
    }

    static List<String> getWithNewlinesInternal(String s2) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\\' && i < s2.length() - 1) {
                char c2 = s2.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return result;
    }

    private FontConfiguration getFontConfiguration(Mode mode) {
        if (mode == Mode.NORMAL) {
            return this.fontConfiguration;
        }
        return this.fontConfiguration.bold();
    }

    public void analyzeAndAddLine(String line) {
        this.analyzeAndAddInternal(line);
    }

    static enum Mode {
        HEADER,
        NORMAL;

    }
}

