/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.command;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandColorTask
extends SingleLineCommand2<GanttDiagram> {
    public CommandColorTask() {
        super(CommandColorTask.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandColorTask.class.getName(), RegexLeaf.start(), new RegexLeaf("CODE", "\\[([%pLN_.]+)\\]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COLORS", "#(\\w+)(?:/(#?\\w+))?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String code = arg.get("CODE", 0);
        Task task = diagram.getExistingTask(code);
        if (task == null) {
            return CommandExecutionResult.error("No such task " + code);
        }
        String color1 = arg.get("COLORS", 0);
        String color2 = arg.get("COLORS", 1);
        HColor col1 = color1 == null ? null : diagram.getIHtmlColorSet().getColor(color1);
        HColor col2 = color2 == null ? null : diagram.getIHtmlColorSet().getColor(color2);
        task.setColors(new CenterBorderColor(col1, col2));
        return CommandExecutionResult.ok();
    }
}

