/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Splitter;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

abstract class AbstractElementText
extends AbstractElement {
    private final TextBlock block;
    private final FontConfiguration config;
    private final int charLength;

    public AbstractElementText(String text, UFont font, boolean manageLength, ISkinSimple spriteContainer) {
        this.config = this.blackBlueTrue(font);
        if (manageLength) {
            this.charLength = this.getCharNumber(text);
            text = StringUtils.trin(text);
        } else {
            this.charLength = 0;
        }
        this.block = Display.create(text).create(this.config, HorizontalAlignment.LEFT, spriteContainer);
    }

    private int getCharNumber(String text) {
        text = text.replaceAll("<&[-\\w]+>", "00");
        text = Splitter.purgeAllTag(text);
        return text.length();
    }

    protected void drawText(UGraphic ug, double x, double y) {
        this.block.drawU(ug.apply(new UTranslate(x, y)));
    }

    protected XDimension2D getPureTextDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    protected XDimension2D getTextDimensionAt(StringBounder stringBounder, double x) {
        XDimension2D result = this.block.calculateDimension(stringBounder);
        if (this.charLength == 0) {
            return result;
        }
        double dimSpace = this.getSingleSpace(stringBounder);
        return new XDimension2D(Math.max(result.getWidth(), (double)this.charLength * dimSpace), result.getHeight());
    }

    private double getSingleSpace(StringBounder stringBounder) {
        return 8.0;
    }

    protected final FontConfiguration getConfig() {
        return this.config;
    }
}

