/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Newpage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Page;

class PageSplitter {
    private final double fullHeight;
    private final List<Double> positions;
    private final List<Display> titles;
    private final double headerHeight;
    private final double tailHeight;
    private final double signatureHeight;
    private final double newpageHeight;
    private final Display diagramTitle;

    PageSplitter(double fullHeight, double headerHeight, Map<Newpage, Double> newpages, double tailHeight, double signatureHeight, double newpageHeight, Display diagramTitle) {
        this.fullHeight = fullHeight;
        this.diagramTitle = diagramTitle;
        this.titles = new ArrayList<Display>();
        this.positions = new ArrayList<Double>();
        for (Map.Entry<Newpage, Double> ent : newpages.entrySet()) {
            this.titles.add(ent.getKey().getTitle());
            this.positions.add(ent.getValue());
        }
        this.headerHeight = headerHeight;
        this.tailHeight = tailHeight;
        this.signatureHeight = signatureHeight;
        this.newpageHeight = newpageHeight;
    }

    public List<Page> getPages() {
        if (this.positions.size() == 0) {
            return Arrays.asList(this.onePage());
        }
        ArrayList<Page> result = new ArrayList<Page>();
        result.add(this.firstPage());
        for (int i = 0; i < this.positions.size() - 1; ++i) {
            result.add(this.createPage(i));
        }
        result.add(this.lastPage());
        return result;
    }

    private Page lastPage() {
        double newpage1 = this.positions.get(this.positions.size() - 1) - this.newpageHeight;
        double newpage2 = this.fullHeight - this.tailHeight - this.signatureHeight;
        Display title = this.titles.get(this.positions.size() - 1);
        return new Page(this.headerHeight, newpage1, newpage2, this.tailHeight, this.signatureHeight, title);
    }

    private Page firstPage() {
        double newpage1 = this.headerHeight;
        double newpage2 = this.positions.get(0) + this.newpageHeight;
        return new Page(this.headerHeight, newpage1, newpage2, this.tailHeight, 0.0, this.diagramTitle);
    }

    private Page onePage() {
        double newpage1 = this.headerHeight;
        double newpage2 = this.fullHeight - this.tailHeight - this.signatureHeight;
        return new Page(this.headerHeight, newpage1, newpage2, this.tailHeight, this.signatureHeight, this.diagramTitle);
    }

    private Page createPage(int i) {
        double newpage1 = this.positions.get(i) - this.newpageHeight;
        double newpage2 = this.positions.get(i + 1) + this.newpageHeight;
        Display title = this.titles.get(i);
        return new Page(this.headerHeight, newpage1, newpage2, this.tailHeight, 0.0, title);
    }
}

