/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UShape;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;

public class Blotter
implements UDrawable {
    private final XDimension2D dim;
    private final HColor defaultBackcolor;
    private final double round;
    private HColor last;
    private final SortedMap<Double, HColor> changes = new TreeMap<Double, HColor>();

    public Blotter(XDimension2D dim, HColor defaultBackcolor, double round) {
        if (defaultBackcolor == null) {
            defaultBackcolor = HColors.transparent();
        }
        this.round = round;
        this.dim = dim;
        this.defaultBackcolor = defaultBackcolor;
        this.last = defaultBackcolor;
    }

    public String toString() {
        return "" + this.dim + " " + this.defaultBackcolor;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor current = this.defaultBackcolor;
        double y = 0.0;
        int i = 0;
        for (Map.Entry<Double, HColor> ent : this.changes.entrySet()) {
            if (!current.isTransparent()) {
                UShape rect = this.getRectangleBackground(i, ent.getKey() - y);
                ug.apply(current).apply(current.bg()).apply(UTranslate.dy(y)).draw(rect);
            }
            y = ent.getKey();
            current = ent.getValue();
            ++i;
        }
    }

    private UShape getRectangleBackground(int i, double height) {
        double width = this.dim.getWidth();
        if (this.round == 0.0) {
            return URectangle.build(width, height);
        }
        if (this.changes.size() == 1) {
            return URectangle.build(width, height).rounded(this.round);
        }
        if (i == 0) {
            UPath result = UPath.none();
            result.moveTo(this.round / 2.0, 0.0);
            result.lineTo(width - this.round / 2.0, 0.0);
            result.arcTo(this.round / 2.0, this.round / 2.0, 0.0, 0.0, 1.0, width, this.round / 2.0);
            result.lineTo(width, height);
            result.lineTo(0.0, height);
            result.lineTo(0.0, this.round / 2.0);
            result.arcTo(this.round / 2.0, this.round / 2.0, 0.0, 0.0, 1.0, this.round / 2.0, 0.0);
            result.closePath();
            return result;
        }
        if (i == this.changes.size() - 1) {
            UPath result = UPath.none();
            result.moveTo(0.0, 0.0);
            result.lineTo(width, 0.0);
            result.lineTo(width, height - this.round / 2.0);
            result.arcTo(this.round / 2.0, this.round / 2.0, 0.0, 0.0, 1.0, width - this.round / 2.0, height);
            result.lineTo(this.round / 2.0, height);
            result.arcTo(this.round / 2.0, this.round / 2.0, 0.0, 0.0, 1.0, 0.0, height - this.round / 2.0);
            result.lineTo(0.0, 0.0);
            result.closePath();
            return result;
        }
        return URectangle.build(width, height);
    }

    public void closeChanges() {
        this.changes.put(this.dim.getHeight(), this.defaultBackcolor);
    }

    public void addChange(double ypos, HColor color) {
        if (color == null) {
            color = HColors.transparent();
        }
        if (color.equals(this.last)) {
            return;
        }
        this.changes.put(ypos, color);
        this.last = color;
    }
}

