/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleLoader;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.style.Value;

class Context {
    private final List<String> data = new ArrayList<String>();
    private final Map<PName, Value> map = new EnumMap<PName, Value>(PName.class);
    private Context parent;

    Context() {
    }

    public Context push(String newString) {
        if (newString.startsWith(":")) {
            newString = newString.substring(1);
        }
        Context result = new Context();
        result.data.addAll(this.data);
        result.data.add(newString);
        result.parent = this;
        return result;
    }

    public Context pop() {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        return this.parent;
    }

    public String toString() {
        return this.data.toString();
    }

    public int size() {
        return this.data.size();
    }

    public Collection<StyleSignatureBasic> toSignatures() {
        ArrayList<StyleSignatureBasic> results = new ArrayList<StyleSignatureBasic>(Collections.singletonList(StyleSignatureBasic.empty()));
        boolean star = false;
        for (String s2 : this.data) {
            if (s2.endsWith("*")) {
                star = true;
                s2 = s2.substring(0, s2.length() - 1);
            }
            String[] names = s2.split(",");
            ArrayList<StyleSignatureBasic> tmp = new ArrayList<StyleSignatureBasic>();
            for (StyleSignatureBasic ss : results) {
                for (String name : names) {
                    tmp.add(ss.add(name.trim()));
                }
            }
            results = tmp;
        }
        if (star) {
            Iterator<String> it = results.listIterator();
            while (it.hasNext()) {
                StyleSignatureBasic tmp = ((StyleSignatureBasic)it.next()).addStar();
                it.set((String)((Object)tmp));
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    public void putInContext(PName key, Value value) {
        this.map.put(key, value);
    }

    public Collection<Style> toStyles() {
        ArrayList<Style> result = new ArrayList<Style>();
        Collection<StyleSignatureBasic> signatures = this.toSignatures();
        for (StyleSignatureBasic signature : signatures) {
            Map<PName, Value> tmp = this.map;
            if (signature.isWithDot()) {
                tmp = StyleLoader.addPriorityForStereotype(tmp);
            }
            if (tmp.size() <= 0) continue;
            result.add(new Style(signature, tmp));
        }
        return result;
    }
}

