/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityCircle
extends Extremity {
    private static final double radius = 6.0;
    private final XPoint2D dest;
    private final boolean fill;
    private final HColor backgroundColor;

    @Override
    public XPoint2D somePoint() {
        return this.dest;
    }

    public static UDrawable create(XPoint2D center, boolean fill, double angle, HColor backgroundColor) {
        return new ExtremityCircle(center.getX(), center.getY(), fill, angle, backgroundColor);
    }

    private ExtremityCircle(double x, double y, boolean fill, double angle, HColor backgroundColor) {
        this.dest = new XPoint2D(x - 6.0 * Math.cos(angle + 1.5707963267948966), y - 6.0 * Math.sin(angle + 1.5707963267948966));
        this.backgroundColor = backgroundColor;
        this.fill = fill;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(UStroke.withThickness(1.5));
        ug = this.fill ? ug.apply(HColors.changeBack(ug)) : ug.apply(this.backgroundColor.bg());
        ug = ug.apply(new UTranslate(this.dest.getX() - 6.0, this.dest.getY() - 6.0));
        ug.draw(UEllipse.build(12.0, 12.0));
    }

    @Override
    public double getDecorationLength() {
        return 12.0;
    }
}

