/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;

public class EntityImageAssociation
extends AbstractEntityImage {
    private static final int SIZE = 12;
    private final SName sname;

    public EntityImageAssociation(Entity entity, ISkinParam skinParam, SName sname) {
        super(entity, skinParam);
        this.sname = sname;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.diamond);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        double shadow = style.value(PName.Shadowing).asDouble();
        UStroke stroke = style.getStroke();
        diams.setDeltaShadow(shadow);
        ug.apply(borderColor).apply(backgroundColor.bg()).apply(stroke).draw(diams);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

