/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.skin.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekLine;
import znaishaded.net.sourceforge.plantuml.svek.image.ConnectedCircle;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageLollipopInterfaceEye1
extends AbstractEntityImage {
    private static final int SIZE = 24;
    private final TextBlock desc;
    private final Bibliotekon bibliotekon;
    private final Url url;

    public EntityImageLollipopInterfaceEye1(Entity entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder));
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground).bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        double sizeSmall = 14.0;
        double diff = 5.0;
        UEllipse circle1 = UEllipse.build(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            // empty if block
        }
        ug.apply(UStroke.withThickness(1.5)).apply(new UTranslate(5.0, 5.0)).draw(circle1);
        ug = ug.apply(HColors.none().bg());
        XPoint2D pos = this.bibliotekon.getNode(this.getEntity()).getPosition();
        List<SvekLine> lines = this.bibliotekon.getAllLineConnectedTo(this.getEntity());
        UTranslate reverse = UTranslate.point(pos).reverse();
        ConnectedCircle connectedCircle = new ConnectedCircle(12.0);
        for (SvekLine line : lines) {
            XPoint2D pt = line.getMyPoint(this.getEntity());
            pt = reverse.getTranslated(pt);
            connectedCircle.addSecondaryConnection(pt);
        }
        connectedCircle.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

