/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.utils.Log;
import znaishaded.net.sourceforge.plantuml.version.PSystemKeycheck;
import znaishaded.net.sourceforge.plantuml.version.PSystemKeygen;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(UmlSource source, String line) {
        try {
            Pattern p;
            Matcher m3;
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors2(source);
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion2(source);
            }
            if (line.matches("(?i)^stdlib\\s*$")) {
                return PSystemVersion.createStdLib(source);
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot(source);
            }
            if (line.matches("(?i)^keydistributor\\s*$")) {
                return PSystemVersion.createKeyDistributor(source);
            }
            if (line.matches("(?i)^keygen\\s*$")) {
                line = line.trim();
                return new PSystemKeygen(source, "");
            }
            if (line.matches("(?i)^keyimport(\\s+[0-9a-z]+)?\\s*$")) {
                line = line.trim();
                String key = line.substring("keyimport".length()).trim();
                return new PSystemKeygen(source, key);
            }
            if (line.matches("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$") && (m3 = (p = Pattern.compile("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$")).matcher(line)).find()) {
                return new PSystemKeycheck(source, m3.group(1), m3.group(2));
            }
        }
        catch (Exception e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

