/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.front.matter.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterNode;
import znaishaded.org.commonmark.internal.DocumentBlockParser;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.SourceLine;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockParser;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class YamlFrontMatterBlockParser
extends AbstractBlockParser {
    private static final Pattern REGEX_METADATA = Pattern.compile("^[ ]{0,3}([A-Za-z0-9._-]+):\\s*(.*)");
    private static final Pattern REGEX_METADATA_LIST = Pattern.compile("^[ ]+-\\s*(.*)");
    private static final Pattern REGEX_METADATA_LITERAL = Pattern.compile("^\\s*(.*)");
    private static final Pattern REGEX_BEGIN = Pattern.compile("^-{3}(\\s.*)?");
    private static final Pattern REGEX_END = Pattern.compile("^(-{3}|\\.{3})(\\s.*)?");
    private boolean inLiteral = false;
    private String currentKey = null;
    private List<String> currentValues = new ArrayList<String>();
    private YamlFrontMatterBlock block = new YamlFrontMatterBlock();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public void addLine(SourceLine line) {
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        CharSequence line = parserState.getLine().getContent();
        if (REGEX_END.matcher(line).matches()) {
            if (this.currentKey != null) {
                this.block.appendChild(new YamlFrontMatterNode(this.currentKey, this.currentValues));
            }
            return BlockContinue.finished();
        }
        Matcher matcher = REGEX_METADATA.matcher(line);
        if (matcher.matches()) {
            if (this.currentKey != null) {
                this.block.appendChild(new YamlFrontMatterNode(this.currentKey, this.currentValues));
            }
            this.inLiteral = false;
            this.currentKey = matcher.group(1);
            this.currentValues = new ArrayList<String>();
            if ("|".equals(matcher.group(2))) {
                this.inLiteral = true;
            } else if (!"".equals(matcher.group(2))) {
                this.currentValues.add(matcher.group(2));
            }
            return BlockContinue.atIndex(parserState.getIndex());
        }
        if (this.inLiteral) {
            matcher = REGEX_METADATA_LITERAL.matcher(line);
            if (matcher.matches()) {
                if (this.currentValues.size() == 1) {
                    this.currentValues.set(0, this.currentValues.get(0) + "\n" + matcher.group(1).trim());
                } else {
                    this.currentValues.add(matcher.group(1).trim());
                }
            }
        } else {
            matcher = REGEX_METADATA_LIST.matcher(line);
            if (matcher.matches()) {
                this.currentValues.add(matcher.group(1));
            }
        }
        return BlockContinue.atIndex(parserState.getIndex());
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence line = state.getLine().getContent();
            BlockParser parentParser = matchedBlockParser.getMatchedBlockParser();
            if (parentParser instanceof DocumentBlockParser && parentParser.getBlock().getFirstChild() == null && REGEX_BEGIN.matcher(line).matches()) {
                return BlockStart.of(new YamlFrontMatterBlockParser()).atIndex(state.getNextNonSpaceIndex());
            }
            return BlockStart.none();
        }
    }
}

