/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.ext.gfm.tables.TableBody;
import znaishaded.org.commonmark.ext.gfm.tables.TableCell;
import znaishaded.org.commonmark.ext.gfm.tables.TableHead;
import znaishaded.org.commonmark.ext.gfm.tables.TableRow;
import znaishaded.org.commonmark.internal.util.Parsing;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.SourceSpan;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.SourceLine;
import znaishaded.org.commonmark.parser.SourceLines;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<SourceLine> rowLines = new ArrayList<SourceLine>();
    private final List<TableCell.Alignment> columns;

    private TableBlockParser(List<TableCell.Alignment> columns, SourceLine headerLine) {
        this.columns = columns;
        this.rowLines.add(headerLine);
    }

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (Parsing.find('|', state.getLine().getContent(), 0) != -1) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.rowLines.add(line);
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        List<SourceSpan> sourceSpans = this.block.getSourceSpans();
        SourceSpan headerSourceSpan = !sourceSpans.isEmpty() ? sourceSpans.get(0) : null;
        TableHead head = new TableHead();
        if (headerSourceSpan != null) {
            head.addSourceSpan(headerSourceSpan);
        }
        this.block.appendChild(head);
        TableRow headerRow = new TableRow();
        headerRow.setSourceSpans(head.getSourceSpans());
        head.appendChild(headerRow);
        List<SourceLine> headerCells = TableBlockParser.split(this.rowLines.get(0));
        int headerColumns = headerCells.size();
        for (int i = 0; i < headerColumns; ++i) {
            SourceLine cell = headerCells.get(i);
            TableCell tableCell = this.parseCell(cell, i, inlineParser);
            tableCell.setHeader(true);
            headerRow.appendChild(tableCell);
        }
        Node body = null;
        for (int rowIndex = 2; rowIndex < this.rowLines.size(); ++rowIndex) {
            SourceLine rowLine = this.rowLines.get(rowIndex);
            SourceSpan sourceSpan = rowIndex < sourceSpans.size() ? sourceSpans.get(rowIndex) : null;
            List<SourceLine> cells = TableBlockParser.split(rowLine);
            TableRow row = new TableRow();
            if (sourceSpan != null) {
                row.addSourceSpan(sourceSpan);
            }
            for (int i = 0; i < headerColumns; ++i) {
                SourceLine cell = i < cells.size() ? cells.get(i) : SourceLine.of("", null);
                TableCell tableCell = this.parseCell(cell, i, inlineParser);
                row.appendChild(tableCell);
            }
            if (body == null) {
                body = new TableBody();
                this.block.appendChild(body);
            }
            body.appendChild(row);
            body.addSourceSpan(sourceSpan);
        }
    }

    private TableCell parseCell(SourceLine cell, int column, InlineParser inlineParser) {
        TableCell tableCell = new TableCell();
        SourceSpan sourceSpan = cell.getSourceSpan();
        if (sourceSpan != null) {
            tableCell.addSourceSpan(sourceSpan);
        }
        if (column < this.columns.size()) {
            tableCell.setAlignment(this.columns.get(column));
        }
        CharSequence content = cell.getContent();
        int start = Parsing.skipSpaceTab(content, 0, content.length());
        int end = Parsing.skipSpaceTabBackwards(content, content.length() - 1, start);
        inlineParser.parse(SourceLines.of(cell.substring(start, end + 1)), tableCell);
        return tableCell;
    }

    private static List<SourceLine> split(SourceLine line) {
        CharSequence row = line.getContent();
        int cellStart = row.charAt(0) == '|' ? 1 : 0;
        ArrayList<SourceLine> cells = new ArrayList<SourceLine>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = cellStart; i < row.length(); ++i) {
            char c = row.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 < row.length() && row.charAt(i + 1) == '|') {
                        sb.append('|');
                        ++i;
                        continue block4;
                    }
                    sb.append('\\');
                    continue block4;
                }
                case '|': {
                    String content = sb.toString();
                    cells.add(SourceLine.of(content, line.substring(cellStart, i).getSourceSpan()));
                    sb.setLength(0);
                    cellStart = i + 1;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            String content = sb.toString();
            cells.add(SourceLine.of(content, line.substring(cellStart, line.getContent().length()).getSourceSpan()));
        }
        return cells;
    }

    private static List<TableCell.Alignment> parseSeparator(CharSequence s2) {
        ArrayList<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();
        int pipes = 0;
        boolean valid = false;
        int i = 0;
        block5: while (i < s2.length()) {
            char c = s2.charAt(i);
            switch (c) {
                case '|': {
                    ++i;
                    if (++pipes > 1) {
                        return null;
                    }
                    valid = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (pipes == 0 && !columns.isEmpty()) {
                        return null;
                    }
                    boolean left = false;
                    boolean right = false;
                    if (c == ':') {
                        left = true;
                        ++i;
                    }
                    boolean haveDash = false;
                    while (i < s2.length() && s2.charAt(i) == '-') {
                        ++i;
                        haveDash = true;
                    }
                    if (!haveDash) {
                        return null;
                    }
                    if (i < s2.length() && s2.charAt(i) == ':') {
                        right = true;
                        ++i;
                    }
                    columns.add(TableBlockParser.getAlignment(left, right));
                    pipes = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++i;
                    continue block5;
                }
            }
            return null;
        }
        if (!valid) {
            return null;
        }
        return columns;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            SourceLine line;
            SourceLine separatorLine;
            List columns;
            List<SourceLine> paragraphLines = matchedBlockParser.getParagraphLines().getLines();
            if (paragraphLines.size() == 1 && Parsing.find('|', paragraphLines.get(0).getContent(), 0) != -1 && (columns = TableBlockParser.parseSeparator((separatorLine = (line = state.getLine()).substring(state.getIndex(), line.getContent().length())).getContent())) != null && !columns.isEmpty()) {
                SourceLine paragraph = paragraphLines.get(0);
                List headerCells = TableBlockParser.split(paragraph);
                if (columns.size() >= headerCells.size()) {
                    return BlockStart.of(new TableBlockParser(columns, paragraph)).atIndex(state.getIndex()).replaceActiveBlockParser();
                }
            }
            return BlockStart.none();
        }
    }
}

