/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cpp.extensions;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.cpp.parser.CodePart;
import org.testingisdocumenting.znai.cpp.parser.CppSourceCode;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class CppCommentsIncludePlugin
implements IncludePlugin {
    private static final String ZNAI_PREFIX = "@znai";
    private Path cppPath;

    @Override
    public String id() {
        return "cpp-comments";
    }

    @Override
    public IncludePlugin create() {
        return new CppCommentsIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String fileName = pluginParams.getFreeParam();
        this.cppPath = componentsRegistry.resourceResolver().fullPath(fileName);
        String text = componentsRegistry.resourceResolver().textContent(fileName);
        String comments = this.extractComments(text, pluginParams.getOpts());
        MarkupParserResult parserResult = componentsRegistry.defaultParser().parse(this.cppPath, comments);
        return PluginResult.docElements(parserResult.docElement().getContent().stream());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.cppPath));
    }

    private String extractComments(String text, PluginParamsOpts opts) {
        String entry = opts.getRequiredString("entry");
        String body = CppSourceCode.entryBodyOnly(text, entry);
        List<CodePart> parts = CppSourceCode.splitOnComments(body);
        return parts.stream().filter(CodePart::isComment).map(cp -> cp.getData().trim()).filter(c -> c.startsWith(ZNAI_PREFIX)).map(c -> c.replaceAll("^@znai", "").trim()).collect(Collectors.joining("\n\n"));
    }
}

