/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndex;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenXmlUtils;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DoxygenIndexParser {
    private final String content;
    private final DoxygenIndex index;
    private Document document;
    private Node indexNode;
    private DoxygenIndexCompound currentCompound;

    private DoxygenIndexParser(String content) {
        this.content = content;
        this.index = new DoxygenIndex();
    }

    public static DoxygenIndex parse(String content) {
        DoxygenIndexParser parser = new DoxygenIndexParser(content);
        parser.parseXml();
        return parser.index;
    }

    private void parseXml() {
        this.document = XmlUtils.parseXml(this.content);
        this.indexNode = this.findRoot();
        this.parseCompoundNodes();
    }

    private void parseCompoundNodes() {
        XmlUtils.allNestedNodesStreamByName(this.indexNode, "compound").forEach(compoundNode -> {
            NamedNodeMap attributes = compoundNode.getAttributes();
            this.currentCompound = new DoxygenIndexCompound(attributes.getNamedItem("refid").getTextContent(), attributes.getNamedItem("kind").getTextContent(), DoxygenXmlUtils.extractNameNodeText(compoundNode));
            this.index.addCompound(this.currentCompound);
            this.extractMembers((Node)compoundNode);
        });
    }

    private void extractMembers(Node compoundNode) {
        XmlUtils.allNestedNodesStreamByName(compoundNode, "member").forEach(memberNode -> {
            NamedNodeMap attributes = memberNode.getAttributes();
            DoxygenIndexMember member = new DoxygenIndexMember(this.currentCompound, attributes.getNamedItem("refid").getTextContent(), attributes.getNamedItem("kind").getTextContent(), DoxygenXmlUtils.extractNameNodeText(memberNode));
            this.index.addMember(member);
        });
    }

    private Node findRoot() {
        return XmlUtils.nextLevelNodeByName(this.document, "doxygenindex");
    }
}

