/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.upload;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.testingisdocumenting.znai.enterprise.upload.OnUploadFinishedServerHandlers;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.streams.Pump;

public class DocumentationOnlyUploadVertxHandler
implements Handler<HttpServerRequest> {
    private final Vertx vertx;
    private final ZnaiServerConfig config;
    private final String docId;
    private final Path destination;
    private final String actor;

    public DocumentationOnlyUploadVertxHandler(Vertx vertx, ZnaiServerConfig config, String docId, String actor) {
        this.vertx = vertx;
        this.config = config;
        this.docId = docId;
        this.destination = config.getDeployRoot().resolve(docId + ".zip").toAbsolutePath();
        this.actor = actor;
    }

    @Override
    public void handle(HttpServerRequest req) {
        req.pause();
        this.vertx.fileSystem().open(this.destination.toString(), new OpenOptions(), fh -> {
            AsyncFile file = (AsyncFile)fh.result();
            Pump pump = Pump.pump(req, file);
            req.endHandler(eh -> file.close(fch -> {
                req.response().end();
                OnUploadFinishedServerHandlers.onUploadFinished(this.config, this.docId, this.destination, this.actor);
                this.deleteUploadedFile();
            }));
            pump.start();
            req.resume();
        });
    }

    private void deleteUploadedFile() {
        try {
            Files.delete(this.destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

