/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameter;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.parser.table.Row;

public class ApiParametersCsvParser {
    private final ApiParameters apiParameters;
    private final MarkupParser markupParser;
    private final String csvContent;
    private final Path path;

    public static ApiParameters parse(String anchorPrefix, MarkupParser markupParser, String csvContent) {
        return new ApiParametersCsvParser(anchorPrefix, markupParser, csvContent).parse();
    }

    private ApiParametersCsvParser(String anchorPrefix, MarkupParser markupParser, String csvContent) {
        this.markupParser = markupParser;
        this.csvContent = csvContent;
        this.apiParameters = new ApiParameters(anchorPrefix);
        this.path = Paths.get("", new String[0]);
    }

    public ApiParameters parse() {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(this.csvContent, "name", "type", "description");
        tableData.forEachRow(this::parseRow);
        return this.apiParameters;
    }

    private void parseRow(Row row) {
        boolean escapedName;
        String name = (String)row.get(0);
        ApiLinkedText type = new ApiLinkedText((String)row.get(1));
        MarkupParserResult markupParserResult = this.markupParser.parse(this.path, (String)row.get(2));
        List<Map<String, Object>> description = markupParserResult.docElement().contentToListOfMaps();
        boolean bl = escapedName = name.startsWith("'") && name.endsWith("'");
        if (name.contains(".") && !name.contains("..") && !escapedName) {
            this.addNested(name, type, description, markupParserResult.getAllText());
        } else {
            name = escapedName ? name.substring(1, name.length() - 1) : name;
            this.apiParameters.add(name, type, description, markupParserResult.getAllText());
        }
    }

    private void addNested(String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        String[] parts = name.split("\\.");
        ApiParameter apiParameter = this.apiParameters.find(parts[0]);
        for (int i = 1; i < parts.length - 1; ++i) {
            apiParameter = apiParameter.find(parts[i]);
        }
        apiParameter.add(parts[parts.length - 1], type, description, textForSearch);
    }
}

