/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.asciinema;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class AsciinemaIncludePlugin
implements IncludePlugin {
    private AuxiliaryFile auxiliaryFile;

    @Override
    public String id() {
        return "asciinema";
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition();
        params.add("startAt", PluginParamType.NUMBER_OR_STRING, "start the playback at a given time", "10 (seconds) or \"2:03\" (\"mm:ss\")");
        params.add("poster", PluginParamType.STRING, "preview frame to display", "npt:0:32 (0 minutes 32 seconds)");
        params.add("cols", PluginParamType.NUMBER, "number of columns", "120");
        params.add("rows", PluginParamType.NUMBER, "number of rows", "10");
        params.add("idleTimeLimit", PluginParamType.NUMBER, "limit terminal inactivity to a given number of seconds", "2");
        params.add("speed", PluginParamType.NUMBER, "playback speed. value 2 means 2x faster", "2");
        return params;
    }

    @Override
    public IncludePlugin create() {
        return new AsciinemaIncludePlugin();
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(this.auxiliaryFile);
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String path = pluginParams.getFreeParam();
        this.auxiliaryFile = componentsRegistry.resourceResolver().runtimeAuxiliaryFile(path);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        props.put("src", componentsRegistry.docStructure().fullUrl(this.auxiliaryFile.getDeployRelativePath().toString()));
        return PluginResult.docElement("Asciinema", props);
    }
}

