/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser;

import java.util.List;
import java.util.stream.Collectors;

public class JavaIdentifier {
    private final List<String> parentNames;
    private final String name;
    private final String typesInParentheses;

    public JavaIdentifier(List<String> parentNames, String name, String typesInParentheses) {
        this.parentNames = parentNames;
        this.name = name;
        this.typesInParentheses = typesInParentheses;
    }

    public boolean matches(String fullOrPartialName) {
        int openParenthesisIdx = fullOrPartialName.indexOf(40);
        boolean hasTypes = openParenthesisIdx != -1;
        String givenTypes = hasTypes ? fullOrPartialName.substring(openParenthesisIdx) : "";
        String giveNameWithoutTypes = hasTypes ? fullOrPartialName.substring(0, openParenthesisIdx) : fullOrPartialName;
        String[] parts = giveNameWithoutTypes.split("\\.");
        boolean matchName = this.name.equals(parts[parts.length - 1]) && (!hasTypes || this.typesInParentheses.equals(givenTypes));
        return matchName && this.matchesPrefix(parts);
    }

    public String getName() {
        return this.name + this.typesInParentheses;
    }

    public String getFullName() {
        return this.parentNames.isEmpty() ? this.getName() : String.join((CharSequence)".", this.parentNames) + "." + this.getName();
    }

    public String getFullNameWithoutFirstParent() {
        return this.parentNames.size() < 2 ? this.getName() : this.parentNames.stream().skip(1L).collect(Collectors.joining(".")) + "." + this.getName();
    }

    public String toString() {
        return "JavaIdentifier{parentNames=" + String.valueOf(this.parentNames) + ", name='" + this.name + "', typesInParentheses='" + this.typesInParentheses + "'}";
    }

    private boolean matchesPrefix(String[] partsIncludingName) {
        int inputPrefixIdx = partsIncludingName.length - 2;
        for (int parentIdx = this.parentNames.size() - 1; inputPrefixIdx >= 0 && parentIdx >= 0; --inputPrefixIdx, --parentIdx) {
            if (this.parentNames.get(parentIdx).equals(partsIncludingName[inputPrefixIdx])) continue;
            return false;
        }
        return true;
    }
}

