/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.docelement;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.file.AnchorFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.footnote.FootnoteId;
import org.testingisdocumenting.znai.extensions.footnote.ParsedFootnote;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.HeadingTextAndProps;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.structure.AnchorIds;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.StringUtils;
import org.testingisdocumenting.znai.utils.UrlUtils;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.Code;
import znaishaded.org.commonmark.node.Emphasis;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.StrongEmphasis;
import znaishaded.org.commonmark.node.Text;

public class DocElementCreationParserHandler
implements ParserHandler {
    private final ComponentsRegistry componentsRegistry;
    private final Path path;
    private final List<AuxiliaryFile> auxiliaryFiles;
    private final List<String> globalAnchorIds;
    private final List<DocElement> paragraphs;
    private final DocElement docElement;
    private final Deque<DocElement> elementsStack;
    private final Map<FootnoteId, ParsedFootnote> parsedFootnotes;
    private final Map<FootnoteId, Integer> footnoteIdxById;
    private int footnoteIdx;
    private String currentSectionTitle;
    private boolean isSectionStarted;

    public DocElementCreationParserHandler(ComponentsRegistry componentsRegistry, Path path) {
        this.componentsRegistry = componentsRegistry;
        this.path = path;
        this.paragraphs = new ArrayList<DocElement>();
        this.auxiliaryFiles = new ArrayList<AuxiliaryFile>();
        this.globalAnchorIds = new ArrayList<String>();
        this.parsedFootnotes = new HashMap<FootnoteId, ParsedFootnote>();
        this.footnoteIdx = 0;
        this.footnoteIdxById = new HashMap<FootnoteId, Integer>();
        this.docElement = new DocElement("Page");
        this.elementsStack = new ArrayDeque<DocElement>();
        this.elementsStack.add(this.docElement);
        this.currentSectionTitle = "";
        this.isSectionStarted = false;
    }

    public DocElement getDocElement() {
        return this.docElement;
    }

    public List<AuxiliaryFile> getAuxiliaryFiles() {
        return this.auxiliaryFiles;
    }

    public List<String> getGlobalAnchorIds() {
        return this.globalAnchorIds;
    }

    public String getCurrentSectionTitle() {
        return this.currentSectionTitle;
    }

    @Override
    public void onSectionStart(String title, HeadingProps headingProps, Heading heading) {
        this.currentSectionTitle = title;
        if (this.isSectionStarted) {
            this.onSectionEnd();
        }
        Map<String, ?> headingPropsMap = headingProps.props();
        DocStructure docStructure = this.componentsRegistry.docStructure();
        String sectionId = new PageSectionIdTitle(title, headingPropsMap).getId();
        docStructure.onSectionOrSubHeading(this.path, 1, sectionId);
        AnchorIds anchorIds = docStructure.generateUniqueAnchors(this.path, "");
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(headingPropsMap);
        this.addAnchorIdsToProps(props, anchorIds);
        props.put("title", title);
        this.addHeadingContentWhenNotSimple(props, heading);
        this.start("Section", props);
        docStructure.registerLocalAnchors(this.path, anchorIds);
        this.isSectionStarted = true;
    }

    @Override
    public void onSectionEnd() {
        this.currentSectionTitle = "";
        this.isSectionStarted = false;
        if (this.elementsStack.size() > 1) {
            this.end();
        }
    }

    @Override
    public void onSubHeading(int level, String title, HeadingProps headingProps, Heading heading) {
        Map<String, ?> headingPropsMap = headingProps.props();
        String idByTitle = new PageSectionIdTitle(title, headingPropsMap).getId();
        DocStructure docStructure = this.componentsRegistry.docStructure();
        docStructure.onSectionOrSubHeading(this.path, level, idByTitle);
        AnchorIds ids = headingProps.isCustomAnchorIdSet() ? new AnchorIds(headingProps.getAnchorId(), Collections.emptyList()) : docStructure.generateUniqueAnchors(this.path, "");
        docStructure.registerLocalAnchors(this.path, ids);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(headingPropsMap);
        this.addAnchorIdsToProps(props, ids);
        props.put("level", level);
        props.put("title", title);
        this.addHeadingContentWhenNotSimple(props, heading);
        this.append("SubHeading", props);
    }

    @Override
    public void onHardLineBreak() {
        this.append("HardLineBreak", new Object[0]);
    }

    @Override
    public void onSoftLineBreak() {
        this.append("SoftLineBreak", new Object[0]);
    }

    @Override
    public void onParagraphStart() {
        this.start("Paragraph", new Object[0]);
    }

    @Override
    public void onParagraphEnd() {
        DocElement paragraph = this.end();
        this.paragraphs.add(paragraph);
    }

    @Override
    public void onBulletListStart(char bulletMarker, boolean tight) {
        this.start("BulletList", "bulletMarker", Character.valueOf(bulletMarker), "tight", tight);
    }

    @Override
    public void onBulletListEnd() {
        this.end();
    }

    @Override
    public void onOrderedListStart(char delimiter, int startNumber) {
        this.start("OrderedList", "delimiter", Character.valueOf(delimiter), "startNumber", startNumber);
    }

    @Override
    public void onOrderedListEnd() {
        this.end();
    }

    @Override
    public void onListItemStart() {
        this.start("ListItem", new Object[0]);
    }

    @Override
    public void onListItemEnd() {
        this.end();
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        this.append(new DocElement("Table", "table", tableData.toMap()));
    }

    @Override
    public void onFootnoteDefinition(ParsedFootnote footnote) {
        this.parsedFootnotes.put(footnote.id(), footnote);
        this.footnoteIdxById.put(footnote.id(), this.footnoteIdx++);
    }

    @Override
    public void onFootnoteReference(FootnoteId footnoteId) {
        this.append(new DocElement("FootnoteReference", "label", () -> Integer.toString(this.footnoteIdxById.getOrDefault(footnoteId, 0) + 1), "content", () -> this.footnoteContent(footnoteId)));
    }

    @Override
    public void onEmphasisStart() {
        this.start("Emphasis", new Object[0]);
    }

    @Override
    public void onEmphasisEnd() {
        this.end();
    }

    @Override
    public void onStrongEmphasisStart() {
        this.start("StrongEmphasis", new Object[0]);
    }

    @Override
    public void onStrongEmphasisEnd() {
        this.end();
    }

    @Override
    public void onStrikeThroughStart() {
        this.start("StrikeThrough", new Object[0]);
    }

    @Override
    public void onStrikeThroughEnd() {
        this.end();
    }

    @Override
    public void onBlockQuoteStart() {
        this.start("BlockQuote", new Object[0]);
    }

    @Override
    public void onBlockQuoteEnd() {
        this.end();
    }

    @Override
    public void onSimpleText(String value) {
        this.append("SimpleText", "text", value);
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", inlinedCode);
        if (!docReferences.isEmpty()) {
            props.put("references", docReferences.toMap());
        }
        this.append("InlinedCode", props);
    }

    @Override
    public void onLinkStart(Path markupPath, String url) {
        DocUrl docUrl = new DocUrl(markupPath, url);
        boolean isFile = this.isLocalFile(docUrl, url);
        String convertedUrl = isFile ? this.convertAndRegisterLocalFileToUrl(url) : this.validateAndCovertUrl(docUrl);
        this.start("Link", "url", convertedUrl, "isFile", isFile);
    }

    @Override
    public void onLinkEnd() {
        this.end();
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        boolean isExternal = UrlUtils.isExternal(destination);
        if (!isExternal) {
            AuxiliaryFile auxiliaryFile = resourcesResolver.runtimeAuxiliaryFile(destination);
            BufferedImage image = resourcesResolver.imageContent(destination);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("title", title);
            props.put("destination", docStructure.fullUrl(auxiliaryFile.getDeployRelativePath().toString()));
            props.put("alt", alt);
            props.put("inlined", true);
            props.put("fit", true);
            props.put("timestamp", this.componentsRegistry.timeService().fileModifiedTimeMillis(auxiliaryFile.getPath()));
            if (image != null) {
                props.put("width", image.getWidth());
                props.put("height", image.getHeight());
            }
            this.append("Image", props);
            this.auxiliaryFiles.add(auxiliaryFile);
        } else {
            docStructure.validateUrl(this.path, "![]() image", new DocUrl(this.path, destination));
            this.append("Image", "title", title, "destination", destination, "alt", alt, "fit", true, "inlined", true);
        }
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        final String stripped = StringUtils.stripIndentation(snippet);
        Map<String, Object> snippetProps = CodeSnippetsProps.create(lang, stripped);
        snippetProps.put("lineNumber", lineNumber);
        snippetProps.putAll(pluginParams.getOpts().toMap());
        SnippetHighlightFeature highlightFeature = new SnippetHighlightFeature(this.componentsRegistry, pluginParams, new SnippetContentProvider(){

            @Override
            public String snippetContent() {
                return stripped;
            }

            @Override
            public String snippetId() {
                return "embedded-snippet";
            }
        });
        highlightFeature.updateProps(snippetProps);
        AnchorFeature anchorFeature = new AnchorFeature(this.componentsRegistry.docStructure(), this.path, pluginParams);
        anchorFeature.updateProps(snippetProps);
        this.append("Snippet", snippetProps);
    }

    @Override
    public void onThematicBreak() {
        this.append("ThematicBreak", new Object[0]);
    }

    @Override
    public void onHtml(String html, boolean isInlined) {
        if (html.startsWith("<!--")) {
            return;
        }
        this.append("EmbeddedHtml", "html", html, "isInlined", isInlined);
    }

    @Override
    public void onCustomNodeStart(String nodeName, Map<String, ?> attrs) {
        DocElement docElement = new DocElement(nodeName);
        docElement.addProps(attrs);
        this.appendAndPush(docElement);
    }

    @Override
    public void onCustomNode(String nodeName, Map<String, ?> attrs) {
        this.append(nodeName, attrs);
    }

    @Override
    public void onCustomNodeEnd(String nodeName) {
        this.end();
    }

    @Override
    public void onDocElement(DocElement docElement) {
        this.append(docElement);
    }

    @Override
    public void onGlobalAnchor(String id) {
        this.componentsRegistry.docStructure().registerGlobalAnchor(this.path, id);
        this.append("Anchor", "id", id);
    }

    @Override
    public void onGlobalAnchorRefStart(String id) {
        String anchorUrl = this.componentsRegistry.docStructure().globalAnchorUrl(this.path, id);
        this.onLinkStart(this.path, anchorUrl);
    }

    @Override
    public void onGlobalAnchorRefEnd() {
        this.onLinkEnd();
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        this.processPlugin(includePlugin, pluginResult);
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        this.processPlugin(fencePlugin, pluginResult);
    }

    @Override
    public void onInlinedCodePlugin(InlinedCodePlugin inlinedCodePlugin, PluginResult pluginResult) {
        this.processPlugin(inlinedCodePlugin, pluginResult);
    }

    private <E extends Plugin> void processPlugin(E plugin, PluginResult result) {
        plugin.auxiliaryFiles(this.componentsRegistry).forEach(this.auxiliaryFiles::add);
        List<DocElement> docElements = result.getDocElements();
        if (docElements.isEmpty()) {
            return;
        }
        docElements.forEach(el -> {
            if (el.getType().equals("Section")) {
                while (this.elementsStack.size() > 1) {
                    this.end();
                }
            }
            this.append((DocElement)el);
        });
    }

    @Override
    public void onParsingEnd() {
        this.removeEmptyParagraphs(this.docElement);
        this.paragraphs.forEach(this::convertParagraphWithSingleImageToWideImage);
    }

    private void removeEmptyParagraphs(DocElement element) {
        List<DocElement> emptyParagraphs = element.getContent().stream().filter(e -> e.getType().equals("Paragraph") && e.getContent().isEmpty()).toList();
        emptyParagraphs.forEach(element::removeChild);
        element.getContent().forEach(this::removeEmptyParagraphs);
    }

    private void convertParagraphWithSingleImageToWideImage(DocElement paragraph) {
        if (paragraph.getContent().size() != 1) {
            return;
        }
        DocElement singleElement = paragraph.getContent().get(0);
        if (!singleElement.getType().equals("Image")) {
            return;
        }
        paragraph.setType(singleElement.getType());
        singleElement.getProps().forEach(paragraph::addProp);
        paragraph.addProp("inlined", false);
        paragraph.removeChild(singleElement);
    }

    private void start(String type, Object ... propsKeyValue) {
        this.appendAndPush(new DocElement(type, propsKeyValue));
    }

    private void start(String type, Map<String, ?> propsKeyValue) {
        DocElement element = new DocElement(type);
        element.addProps(propsKeyValue);
        this.appendAndPush(element);
    }

    private DocElement end() {
        return this.elementsStack.removeLast();
    }

    private void append(String type, Object ... propsKeyValue) {
        this.append(new DocElement(type, propsKeyValue));
    }

    private void append(String type, Map<String, ?> propsKeyValue) {
        DocElement element = new DocElement(type);
        element.addProps(propsKeyValue);
        this.append(element);
    }

    private void append(DocElement element) {
        this.elementsStack.peekLast().addChild(element);
    }

    private void appendAndPush(DocElement element) {
        this.elementsStack.peekLast().addChild(element);
        this.elementsStack.add(element);
    }

    private String validateAndCovertUrl(DocUrl docUrl) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        docStructure.validateUrl(this.path, "section title: " + this.currentSectionTitle, docUrl);
        return docStructure.createUrl(this.path, docUrl);
    }

    private boolean isLocalFile(DocUrl docUrl, String url) {
        if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("mailto:")) {
            return false;
        }
        TocItem tocItem = this.componentsRegistry.docStructure().tableOfContents().findTocItem(docUrl.getDirName(), docUrl.getFileNameWithoutExtension());
        if (tocItem != null) {
            return false;
        }
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        return url.indexOf(46) != -1 && resourcesResolver.isLocalFile(url);
    }

    private String convertAndRegisterLocalFileToUrl(String url) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        AuxiliaryFile auxiliaryFile = resourcesResolver.runtimeAuxiliaryFile(url);
        this.auxiliaryFiles.add(auxiliaryFile);
        return docStructure.fullUrl(auxiliaryFile.getDeployRelativePath().toString());
    }

    private void addAnchorIdsToProps(Map<String, Object> props, AnchorIds ids) {
        props.put("id", ids.main());
        props.put("additionalIds", ids.additional());
    }

    private List<Map<String, Object>> footnoteContent(FootnoteId footnoteId) {
        ParsedFootnote parsedFootnote = this.parsedFootnotes.get(footnoteId);
        if (parsedFootnote == null) {
            throw new IllegalArgumentException("can't find footnote with id <" + String.valueOf(footnoteId) + ">");
        }
        return parsedFootnote.docElement().contentToListOfMaps();
    }

    private void addHeadingContentWhenNotSimple(Map<String, Object> props, Heading heading) {
        final DocElementCreationParserHandler parserHandler = new DocElementCreationParserHandler(this.componentsRegistry, this.path);
        if (heading == null) {
            return;
        }
        heading.accept(new AbstractVisitor(){

            @Override
            public void visit(Text text) {
                parserHandler.onSimpleText(HeadingTextAndProps.extractTextAndProps(text.getLiteral()).text());
            }

            @Override
            public void visit(Link link) {
                parserHandler.onLinkStart(DocElementCreationParserHandler.this.path, link.getDestination());
                this.visitChildren(link);
                parserHandler.onLinkEnd();
            }

            @Override
            public void visit(Code code) {
                parserHandler.onInlinedCode(code.getLiteral(), DocReferences.EMPTY);
            }

            @Override
            public void visit(Emphasis emphasis) {
                parserHandler.onEmphasisStart();
                this.visitChildren(emphasis);
                parserHandler.onEmphasisEnd();
            }

            @Override
            public void visit(StrongEmphasis strongEmphasis) {
                parserHandler.onStrongEmphasisStart();
                this.visitChildren(strongEmphasis);
                parserHandler.onStrongEmphasisEnd();
            }
        });
        List<Map<String, Object>> content = parserHandler.docElement.contentToListOfMaps();
        if (content.isEmpty() || content.size() == 1 && content.get(0).get("type").equals("SimpleText")) {
            return;
        }
        props.put("headingContent", content);
    }
}

