/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.reference;

import java.util.Map;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class DocReferencesParser {
    private DocReferencesParser() {
    }

    public static DocReferences parse(String content) {
        return (content = content.trim()).startsWith("{") ? DocReferencesParser.parseJson(content) : DocReferencesParser.parseCsv(content);
    }

    public static DocReferences parseJson(String content) {
        Map<String, ?> jsonReferences = JsonUtils.deserializeAsMap(content);
        DocReferences result = new DocReferences();
        jsonReferences.forEach((k, v) -> result.add((String)k, v.toString()));
        return result;
    }

    public static DocReferences parseCsv(String content) {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(content, "reference", "url");
        DocReferences result = new DocReferences();
        tableData.forEachRow(row -> result.add((String)row.get(0), (String)row.get(1)));
        return result;
    }
}

