/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.search;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.search.PageLocalSearchEntries;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class LocalSearchEntries {
    private final Map<TocItem, PageLocalSearchEntries> entries = new LinkedHashMap<TocItem, PageLocalSearchEntries>();

    public void add(PageLocalSearchEntries entries) {
        this.entries.put(entries.tocItem(), entries);
    }

    public PageLocalSearchEntries searchEntriesByTocItem(TocItem tocItem) {
        return this.entries.get(tocItem);
    }

    public List<List<String>> toListOfLists() {
        return this.entries.values().stream().flatMap(e -> e.toListOfLists().stream()).collect(Collectors.toList());
    }

    public String buildIndexScript() {
        return "window.znaiSearchData = " + JsonUtils.serialize(this.toListOfLists()) + "\n" + ResourceUtils.textContent("lunrjs/indexCreation.js");
    }
}

