/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.text;

import org.testingisdocumenting.znai.text.TextLinesAccessor;

public class RegionScopeExtractor {
    private final int startLineIdx;
    private String scopeStart;
    private String scopeEnd;
    private final TextLinesAccessor linesAccessor;
    private boolean insideSingleQuote;
    private boolean insideDoubleQuote;
    private boolean isSingleCharScope;
    private int resultStartLineIdx;
    private int resultEndLineIdx;

    public RegionScopeExtractor(TextLinesAccessor linesAccessor, int startLineIdx, String scopeDefinition) {
        this.linesAccessor = linesAccessor;
        this.startLineIdx = startLineIdx;
        this.extractScope(scopeDefinition);
    }

    public int getResultStartLineIdx() {
        return this.resultStartLineIdx;
    }

    public int getResultEndLineIdx() {
        return this.resultEndLineIdx;
    }

    public void process() {
        int scopeBalance = 0;
        boolean encounteredScopeStart = false;
        this.resultStartLineIdx = -1;
        this.resultEndLineIdx = -1;
        for (int lineIdx = this.startLineIdx; lineIdx < this.linesAccessor.numberOfLines(); ++lineIdx) {
            String line = this.linesAccessor.lineAtIdx(lineIdx);
            int previousChar = 32;
            for (int charIdx = 0; charIdx < line.length(); ++charIdx) {
                boolean isPreviousCharEscape;
                char c = line.charAt(charIdx);
                if (!this.insideSingleQuote && !this.insideDoubleQuote) {
                    boolean scopeStartMatch = this.matchSubstr(line, charIdx, this.scopeStart);
                    boolean scopeEndMatch = this.matchSubstr(line, charIdx, this.scopeEnd);
                    if (scopeStartMatch) {
                        charIdx += this.scopeStart.length() - 1;
                        if (!encounteredScopeStart) {
                            this.resultStartLineIdx = Math.min(this.startLineIdx, lineIdx);
                            encounteredScopeStart = true;
                        }
                        ++scopeBalance;
                    } else if (scopeEndMatch) {
                        charIdx += this.scopeEnd.length() - 1;
                        if (--scopeBalance < 0) {
                            return;
                        }
                        if (scopeBalance == 0) {
                            this.resultEndLineIdx = lineIdx;
                            return;
                        }
                    }
                }
                boolean bl = isPreviousCharEscape = previousChar == 92;
                if (c == '\"' && !isPreviousCharEscape) {
                    boolean bl2 = this.insideDoubleQuote = !this.insideDoubleQuote;
                }
                if (c == '\'' && !isPreviousCharEscape) {
                    this.insideSingleQuote = !this.insideSingleQuote;
                }
                previousChar = c;
            }
        }
    }

    private boolean matchSubstr(String line, int charIdx, String substr) {
        if (this.isSingleCharScope) {
            return line.charAt(charIdx) == substr.charAt(0);
        }
        int idx = charIdx;
        int lineLen = line.length();
        int subLen = substr.length();
        if (idx + subLen > lineLen) {
            return false;
        }
        if (idx > 0 && !this.isSeparator(line.charAt(idx - 1))) {
            return false;
        }
        for (int subIdx = 0; subIdx < subLen && idx < lineLen; ++subIdx, ++idx) {
            char subC;
            char sourceC = line.charAt(idx);
            if (sourceC == (subC = substr.charAt(subIdx))) continue;
            return false;
        }
        return idx >= lineLen || this.isSeparator(line.charAt(idx));
    }

    private boolean isSeparator(char c) {
        return !Character.isAlphabetic(c) && !Character.isDigit(c);
    }

    private void extractScope(String scopeDefinition) {
        if (scopeDefinition.length() == 2) {
            this.scopeStart = String.valueOf(scopeDefinition.charAt(0));
            this.scopeEnd = String.valueOf(scopeDefinition.charAt(1));
            this.isSingleCharScope = true;
        } else if (scopeDefinition.contains(",") && scopeDefinition.length() > 2) {
            int commaIdx = scopeDefinition.indexOf(44);
            this.scopeStart = scopeDefinition.substring(0, commaIdx);
            this.scopeEnd = scopeDefinition.substring(commaIdx + 1);
            this.isSingleCharScope = this.scopeStart.length() == 1 && this.scopeEnd.length() == 1;
        } else {
            throw new IllegalArgumentException("scope should be defined either as two chars like \"{}\", \"[]\", or comma separated two strings \"sig,end\", \"let,in\"");
        }
    }
}

