/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.console.ansi.FontStyle;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.AuxiliaryFilesRegistry;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.core.Log;
import org.testingisdocumenting.znai.core.MarkupPathWithError;
import org.testingisdocumenting.znai.extensions.PluginParamsWithDefaultsFactory;
import org.testingisdocumenting.znai.extensions.Plugins;
import org.testingisdocumenting.znai.html.Deployer;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.html.PageToHtmlPageConverter;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.html.ServerSideSimplifiedRenderer;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.parser.MarkupParsingConfigurations;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.preprocessor.RegexpBasedPreprocessor;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.reference.GlobalDocReferences;
import org.testingisdocumenting.znai.resources.ClassPathResourceResolver;
import org.testingisdocumenting.znai.resources.HttpBasedResourceResolver;
import org.testingisdocumenting.znai.resources.MultipleLocalLocationsResourceResolver;
import org.testingisdocumenting.znai.resources.ResourcesResolverChain;
import org.testingisdocumenting.znai.resources.UnresolvedResourceException;
import org.testingisdocumenting.znai.resources.ZipJarFileResourceResolver;
import org.testingisdocumenting.znai.search.GlobalSearchEntries;
import org.testingisdocumenting.znai.search.GlobalSearchEntry;
import org.testingisdocumenting.znai.search.LocalSearchEntries;
import org.testingisdocumenting.znai.search.PageLocalSearchEntries;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.Page;
import org.testingisdocumenting.znai.structure.PageMeta;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.website.FooterAndParseResult;
import org.testingisdocumenting.znai.website.ProgressReporter;
import org.testingisdocumenting.znai.website.TocAddedUpdatedAndRemovedPages;
import org.testingisdocumenting.znai.website.TocChangeListener;
import org.testingisdocumenting.znai.website.WebResource;
import org.testingisdocumenting.znai.website.WebSiteComponentsRegistry;
import org.testingisdocumenting.znai.website.WebSiteDocStructure;
import org.testingisdocumenting.znai.website.WebSiteGlobalOverridePlaceholderExtension;
import org.testingisdocumenting.znai.website.WebSiteLogoExtension;
import org.testingisdocumenting.znai.website.WebSiteResourcesProviders;
import org.testingisdocumenting.znai.website.WebSiteUserExtensions;
import org.testingisdocumenting.znai.website.modifiedtime.FileBasedPageModifiedTime;
import org.testingisdocumenting.znai.website.modifiedtime.PageModifiedTimeStrategy;

public class WebSite
implements Log {
    private static final String UPLOAD_FILE_NAME = "upload.txt";
    private static final String SEARCH_INDEX_FILE_NAME = "search-index.js";
    private final PluginParamsWithDefaultsFactory pluginParamsFactory;
    private final Set<TocChangeListener> tocChangeListeners;
    private PageToHtmlPageConverter pageToHtmlPageConverter;
    private MarkupParser markupParser;
    private final Deployer deployer;
    private final DocMeta docMeta;
    private final Configuration cfg;
    private Map<TocItem, Page> pageByTocItem;
    private final GlobalSearchEntries globalSearchEntries;
    private final LocalSearchEntries localSearchEntries;
    private TableOfContents toc;
    private final GlobalDocReferences globalDocReferences;
    private WebSiteDocStructure docStructure;
    private Footer footer;
    private Map<TocItem, DocPageReactProps> pagePropsByTocItem;
    private final List<WebResource> registeredExtraJavaScripts;
    private List<WebResource> extraJavaScriptsInFront;
    private List<WebResource> extraJavaScriptsInBack;
    private final WebSiteComponentsRegistry componentsRegistry;
    private final AuxiliaryFilesRegistry auxiliaryFilesRegistry;
    private final WebResource tocJavaScript;
    private final WebResource footerJavaScript;
    private final WebResource globalAssetsJavaScript;
    private final WebResource globalDocReferencesJavaScript;
    private final WebResource searchIndexJavaScript;
    private MultipleLocalLocationsResourceResolver localResourceResolver;
    private final ResourcesResolverChain resourceResolver;
    private final MarkupParsingConfiguration markupParsingConfiguration;
    private final Map<AuxiliaryFile, Long> auxiliaryFilesLastUpdateTime;
    private final PageModifiedTimeStrategy pageModifiedTimeStrategy;
    private RegexpBasedPreprocessor regexpBasedPreprocessor;

    private WebSite(Configuration siteConfig) {
        this.cfg = siteConfig;
        this.deployer = new Deployer(siteConfig.docRootPath, siteConfig.deployPath);
        this.docMeta = siteConfig.docMeta;
        this.pageModifiedTimeStrategy = siteConfig.pageModifiedTimeStrategy != null ? siteConfig.pageModifiedTimeStrategy : new FileBasedPageModifiedTime();
        this.tocChangeListeners = new HashSet<TocChangeListener>();
        this.registeredExtraJavaScripts = siteConfig.registeredExtraJavaScripts;
        this.componentsRegistry = new WebSiteComponentsRegistry(siteConfig.docRootPath, siteConfig.isValidateExternalLinks);
        this.componentsRegistry.setLog(this);
        this.pluginParamsFactory = new PluginParamsWithDefaultsFactory();
        this.componentsRegistry.setPluginParamsFactory(this.pluginParamsFactory);
        this.resourceResolver = new ResourcesResolverChain();
        this.tocJavaScript = WebResource.withPath("toc.js");
        this.footerJavaScript = WebResource.withPath("footer.js");
        this.globalAssetsJavaScript = WebResource.withPath("assets.js");
        this.globalDocReferencesJavaScript = WebResource.withPath("documentation-references.js");
        this.searchIndexJavaScript = WebResource.moduleWithPath(SEARCH_INDEX_FILE_NAME);
        this.auxiliaryFilesRegistry = new AuxiliaryFilesRegistry();
        this.markupParsingConfiguration = MarkupParsingConfigurations.byName(this.cfg.documentationType);
        this.globalSearchEntries = new GlobalSearchEntries();
        this.localSearchEntries = new LocalSearchEntries();
        this.auxiliaryFilesLastUpdateTime = new HashMap<AuxiliaryFile, Long>();
        this.globalDocReferences = new GlobalDocReferences(this.componentsRegistry, this.cfg.globalReferencesPathNoExt);
        this.docMeta.setId(siteConfig.id);
        if (siteConfig.isPreviewEnabled) {
            this.docMeta.setPreviewEnabled(true);
        }
        this.reset();
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public static Configuration withRoot(Path path) {
        Configuration configuration = new Configuration();
        configuration.withRootPath(path);
        return configuration;
    }

    public void regenerate() {
        this.reset();
        this.parseAndDeploy();
    }

    public AuxiliaryFilesRegistry getAuxiliaryFilesRegistry() {
        return this.auxiliaryFilesRegistry;
    }

    public Path getDeployRoot() {
        return this.cfg.deployPath;
    }

    public DocMeta getDocMeta() {
        return this.docMeta;
    }

    public Map<String, Path> getOutsideDocsRequestedResources() {
        return this.resourceResolver.getOutsideDocRequestedResources();
    }

    public void parseAndDeploy() {
        this.parse();
        this.deploy();
    }

    public void parse() {
        this.createResourceResolvers();
        this.registerPreprocessor();
        this.registerSiteResourceProviders();
        this.createTopLevelToc();
        this.createDocStructure();
        this.parseAndSetPluginGlobalParams();
        this.parseGlobalDocReference();
        this.resolveTocItemsPath();
        this.parseMarkupsMeta();
        this.parseMarkups();
        this.parseFooter();
        this.updateTocWithPageSections();
        this.validateCollectedLinks();
    }

    private void registerPreprocessor() {
        this.regexpBasedPreprocessor = this.resourceResolver.canResolve("preprocessor.csv") ? new RegexpBasedPreprocessor(this.resourceResolver.textContent("preprocessor.csv")) : new RegexpBasedPreprocessor(Collections.emptyList());
    }

    public void deploy() {
        ProgressReporter.reportPhase("deploying documentation");
        this.generatePages();
        this.generateSearchIndex();
        this.deployToc();
        this.deployFooter();
        this.deployMeta();
        this.deployGlobalAssets();
        this.deployGlobalDocReferences();
        this.deployAuxiliaryFiles();
        this.deployUploadFiles();
        this.deployResources();
        this.deployPluginsStats();
    }

    public TocItem tocItemByPath(Path path) {
        return this.markupParsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path);
    }

    public HtmlPageAndPageProps regenerateAndValidatePageDeployTocAndAllPages(TocItem tocItem) {
        this.removeLinksForTocItem(tocItem);
        HtmlPageAndPageProps pageProps = this.regeneratePageOnly(tocItem);
        this.deployToc();
        this.docStructure.validateCollectedLinks();
        this.buildJsonOfAllPages();
        return pageProps;
    }

    public void removeLinksForTocItem(TocItem tocItem) {
        MarkupPathWithError markupPathWithError = this.resolveTocItem(tocItem);
        if (markupPathWithError.path() == null) {
            return;
        }
        this.docStructure.removeGlobalAnchorsForPath(markupPathWithError.path());
        this.docStructure.removeLocalAnchorsForTocItem(tocItem);
        this.docStructure.removeLinksForPath(markupPathWithError.path());
    }

    public HtmlPageAndPageProps regeneratePageOnly(TocItem tocItem) {
        this.parseMarkupMetaOnlyAndUpdateTocItem(tocItem);
        this.parseMarkupAndUpdateTocItemAndSearch(tocItem);
        Page page = this.pageByTocItem.get(tocItem);
        tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles());
        HtmlPageAndPageProps pageProps = this.generatePage(tocItem, page);
        this.auxiliaryFilesRegistry.auxiliaryFilesByTocItem(tocItem).stream().filter(AuxiliaryFile::isDeploymentRequired).forEach(this::deployAuxiliaryFileIfOutdated);
        return pageProps;
    }

    public Set<TocItem> dependentTocItems(Path auxiliaryFile) {
        return this.auxiliaryFilesRegistry.tocItemsByPath(auxiliaryFile);
    }

    public TableOfContents getToc() {
        return this.toc;
    }

    public TocAddedUpdatedAndRemovedPages updateToc() {
        TableOfContents previousToc = this.toc;
        this.createTopLevelToc();
        this.docStructure.updateToc(this.toc);
        this.resolveTocItemsPath();
        List<TocItem> newTocItems = previousToc.detectNewTocItems(this.toc);
        List<TocItem> removedTocItems = previousToc.detectRemovedTocItems(this.toc);
        List<TocItem> changedTocItems = previousToc.detectChangedTocItems(this.toc);
        removedTocItems.forEach(this::removeLinksForTocItem);
        List<HtmlPageAndPageProps> addedOrUpdatedPages = Stream.concat(newTocItems.stream(), changedTocItems.stream()).map(tocItem -> {
            this.parseMarkupAndUpdateTocItemAndSearch((TocItem)tocItem);
            return this.regeneratePageOnly((TocItem)tocItem);
        }).collect(Collectors.toList());
        this.updateTocWithPageSections();
        this.docStructure.validateCollectedLinks();
        this.deployToc();
        return new TocAddedUpdatedAndRemovedPages(this.toc, addedOrUpdatedPages, removedTocItems);
    }

    public DocReferences updateDocReferences() {
        this.docStructure.removeLinksForPath(this.globalDocReferences.getGlobalReferencesPathNoExt());
        this.globalDocReferences.load();
        this.deployGlobalDocReferences();
        this.validateCollectedLinks();
        return this.globalDocReferences.getDocReferences();
    }

    public FooterAndParseResult parseFooter() {
        Path markupPath = this.cfg.footerPath;
        if (!Files.exists(markupPath, new LinkOption[0])) {
            return null;
        }
        ProgressReporter.reportPhase("parsing footer");
        this.localResourceResolver.setCurrentFilePath(markupPath);
        MarkupParserResult parserResult = this.markupParser.parse(markupPath, FileUtils.fileTextContent(markupPath));
        this.auxiliaryFilesRegistry.registerAdditionalAuxiliaryFiles(parserResult.auxiliaryFiles());
        this.footer = new Footer(parserResult.docElement());
        return new FooterAndParseResult(this.footer, parserResult);
    }

    public Footer updateFooter() {
        FooterAndParseResult footerAndParseResult = this.parseFooter();
        footerAndParseResult.parserResult().auxiliaryFiles().stream().filter(AuxiliaryFile::isDeploymentRequired).forEach(this::deployAuxiliaryFileIfOutdated);
        return footerAndParseResult.footer();
    }

    public void redeployAuxiliaryFileIfRequired(Path path) {
        if (this.auxiliaryFilesRegistry.requiresDeployment(path)) {
            this.deployAuxiliaryFile(this.auxiliaryFilesRegistry.auxiliaryFileByPath(path));
        }
    }

    private WebSiteUserExtensions initFileBasedWebSiteExtension(Configuration cfg) {
        if (cfg.extensionsDefPath == null || !Files.exists(cfg.extensionsDefPath, new LinkOption[0])) {
            return new WebSiteUserExtensions(this.resourceResolver, Collections.emptyMap());
        }
        String json = FileUtils.fileTextContent(cfg.extensionsDefPath);
        return new WebSiteUserExtensions(this.resourceResolver, JsonUtils.deserializeAsMap(json));
    }

    private void reset() {
        this.pageToHtmlPageConverter = new PageToHtmlPageConverter(this.docMeta, ReactJsBundle.INSTANCE);
        this.markupParser = this.markupParsingConfiguration.createMarkupParser(this.componentsRegistry);
        this.pageByTocItem = new LinkedHashMap<TocItem, Page>();
        this.pagePropsByTocItem = new LinkedHashMap<TocItem, DocPageReactProps>();
        this.extraJavaScriptsInFront = new ArrayList<WebResource>(this.registeredExtraJavaScripts);
        this.extraJavaScriptsInFront.add(this.globalAssetsJavaScript);
        if (this.globalDocReferences.isPresent()) {
            this.extraJavaScriptsInFront.add(this.globalDocReferencesJavaScript);
        }
        this.extraJavaScriptsInFront.add(this.tocJavaScript);
        this.extraJavaScriptsInFront.add(this.footerJavaScript);
        this.extraJavaScriptsInBack = new ArrayList<WebResource>(this.registeredExtraJavaScripts);
        this.extraJavaScriptsInBack.add(this.searchIndexJavaScript);
        this.componentsRegistry.setDefaultParser(this.markupParser);
        this.componentsRegistry.setMarkdownParser(new MarkdownParser(this.componentsRegistry));
    }

    private void deployResources() {
        ProgressReporter.reportPhase("deploying resources");
        ReactJsBundle.INSTANCE.deploy(this.deployer);
        WebSiteResourcesProviders.cssResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.jsResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.jsClientOnlyResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.additionalFilesToDeploy().forEach(this.deployer::deploy);
        this.cfg.webResources.forEach(this.deployer::deploy);
    }

    private void createTopLevelToc() {
        ProgressReporter.reportPhase("creating table of contents");
        this.toc = this.markupParsingConfiguration.createToc(this.docMeta.getTitle(), this.componentsRegistry);
    }

    private void createDocStructure() {
        this.docStructure = new WebSiteDocStructure(this.componentsRegistry, this.docMeta, this.toc, this.markupParsingConfiguration);
        this.componentsRegistry.setDocStructure(this.docStructure);
    }

    private void createResourceResolvers() {
        this.componentsRegistry.setResourcesResolver(this.resourceResolver);
        this.localResourceResolver = new MultipleLocalLocationsResourceResolver(this.toc, this.cfg.docRootPath);
        this.resourceResolver.addResolver(this.localResourceResolver);
        this.resourceResolver.addResolver(new ZipJarFileResourceResolver(this, this.cfg.docRootPath));
        this.resourceResolver.addResolver(new ClassPathResourceResolver());
        this.resourceResolver.addResolver(new HttpBasedResourceResolver());
        List<String> lookupLocations = this.findLookupLocations(this.cfg).toList();
        this.printLookupLocations(lookupLocations.stream());
        this.resourceResolver.initialize(lookupLocations.stream());
    }

    private void registerSiteResourceProviders() {
        WebSiteResourcesProviders.add(new WebSiteLogoExtension(this.cfg.docRootPath));
        WebSiteResourcesProviders.add(new WebSiteGlobalOverridePlaceholderExtension());
        WebSiteResourcesProviders.add(this.initFileBasedWebSiteExtension(this.cfg));
    }

    private void parseGlobalDocReference() {
        ProgressReporter.reportPhase("parsing global doc references");
        this.globalDocReferences.load();
    }

    private void updateTocWithPageSections() {
        this.forEachPage((tocItem, page) -> {
            if (page == null) {
                if (tocItem.isIndex()) {
                    return;
                }
                throw new IllegalStateException("no parsed page associated with " + String.valueOf(tocItem));
            }
            tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles());
        });
    }

    private void deployToc() {
        ProgressReporter.reportPhase("deploying table of contents");
        String tocJson = JsonUtils.serializePrettyPrint(this.toc.toListOfMaps());
        this.deployer.deploy(this.tocJavaScript, "toc = " + tocJson);
    }

    private void deployFooter() {
        ProgressReporter.reportPhase("deploying footer");
        String footerJson = this.footer != null ? JsonUtils.serializePrettyPrint(this.footer.toMap()) : "undefined";
        this.deployer.deploy(this.footerJavaScript, "footer = " + footerJson);
    }

    private void deployMeta() {
        ProgressReporter.reportPhase("deploying meta");
        this.deployer.deploy("meta.json", JsonUtils.serializePrettyPrint(this.docMeta.toMap()));
    }

    private void deployGlobalAssets() {
        ProgressReporter.reportPhase("deploying global plugin assets");
        String globalAssetsJson = JsonUtils.serializePrettyPrint(this.componentsRegistry.globalAssetsRegistry().getAssets());
        this.deployer.deploy(this.globalAssetsJavaScript, "globalAssets = " + globalAssetsJson);
    }

    private void deployGlobalDocReferences() {
        if (!this.globalDocReferences.isPresent()) {
            return;
        }
        ProgressReporter.reportPhase("deploying global documentation references");
        String globalReferences = JsonUtils.serializePrettyPrint(this.globalDocReferences.getDocReferences().toMap());
        this.deployer.deploy(this.globalDocReferencesJavaScript, "docReferences = " + globalReferences);
    }

    private void resolveTocItemsPath() {
        ProgressReporter.reportPhase("validate TOC items");
        List<TocItem> missingTocItems = this.toc.resolveTocItemPathsAndReturnMissing(this::resolveTocItem);
        if (!missingTocItems.isEmpty()) {
            String renderedMissingTocItems = "    " + missingTocItems.stream().map(tocItem -> tocItem.toString() + ": can't find " + this.markupParsingConfiguration.tocItemResourceName((TocItem)tocItem)).collect(Collectors.joining("\n    "));
            throw new RuntimeException("\nFollowing Table of Contents entries are missing associated files:\n\n" + renderedMissingTocItems + "\n");
        }
        Collection<Path> tocItemPaths = this.toc.getResolvedPaths();
        this.tocChangeListeners.forEach(l -> l.onTocResolvedFiles(tocItemPaths));
    }

    private void parseMarkupsMeta() {
        ProgressReporter.reportPhase("parsing markup files meta");
        this.toc.getTocItems().forEach(this::parseMarkupMetaOnlyAndUpdateTocItem);
    }

    private void parseMarkups() {
        ProgressReporter.reportPhase("parsing markup files");
        this.toc.getTocItems().forEach(this::parseMarkupAndUpdateTocItemAndSearch);
    }

    private void parseMarkupMetaOnlyAndUpdateTocItem(TocItem tocItem) {
        MarkupPathWithError markupPathWithError = MarkupPathWithError.EMPTY;
        try {
            markupPathWithError = this.resolveTocItem(tocItem);
            if (markupPathWithError.path() == null && tocItem.isIndex()) {
                return;
            }
            if (markupPathWithError.error() != null) {
                throw markupPathWithError.error();
            }
            PageMeta pageMeta = this.markupParser.parsePageMetaOnly(FileUtils.fileTextContent(markupPathWithError.path()));
            this.updateTocItemWithPageMeta(tocItem, pageMeta);
        }
        catch (Exception e) {
            WebSite.throwParsingErrorMessage(tocItem, markupPathWithError.path(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMarkupAndUpdateTocItemAndSearch(TocItem tocItem) {
        MarkupPathWithError markupPathWithError = MarkupPathWithError.EMPTY;
        try {
            markupPathWithError = this.resolveTocItem(tocItem);
            if (markupPathWithError.path() == null) {
                if (tocItem.isIndex()) {
                    return;
                }
                throw markupPathWithError.error();
            }
            Path relativePathToLog = this.cfg.docRootPath.relativize(markupPathWithError.path());
            ConsoleOutputs.out(new Object[]{"parsing ", Color.PURPLE, relativePathToLog});
            this.localResourceResolver.setCurrentFilePath(markupPathWithError.path());
            String markupContent = FileUtils.fileTextContent(markupPathWithError.path());
            markupContent = this.regexpBasedPreprocessor.preprocess(markupContent);
            PageMeta pageMeta = this.markupParser.parsePageMetaOnly(markupContent);
            this.pluginParamsFactory.setPageLocalParams(pageMeta);
            MarkupParserResult parserResult = this.markupParser.parse(markupPathWithError.path(), markupContent);
            this.updateFilesAssociation(tocItem, parserResult.auxiliaryFiles());
            Instant lastModifiedTime = this.pageModifiedTimeStrategy.lastModifiedTime(tocItem, markupPathWithError.path());
            Page page = new Page(parserResult.docElement(), lastModifiedTime, parserResult.pageMeta());
            this.pageByTocItem.put(tocItem, page);
            this.updateTocItemWithPageMeta(tocItem, page.getPageMeta());
            tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles());
            this.updateSearchEntries(tocItem, parserResult);
        }
        catch (Exception e) {
            WebSite.throwParsingErrorMessage(tocItem, markupPathWithError.path(), e);
        }
        finally {
            this.localResourceResolver.setCurrentFilePath(null);
        }
    }

    private static void throwParsingErrorMessage(TocItem tocItem, Path markupPath, Throwable e) {
        throw new RuntimeException("\nmarkup parsing error:\n    TOC item: " + String.valueOf(tocItem) + "\n    full path: " + String.valueOf(markupPath) + "\n\n" + e.getMessage(), e);
    }

    private void updateTocItemWithPageMeta(TocItem tocItem, PageMeta pageMeta) {
        tocItem.setPageMeta(pageMeta);
        if (pageMeta.hasValue("title")) {
            tocItem.setPageTitleIfNoTocOverridePresent((String)pageMeta.getSingleValue("title"));
        } else if (tocItem.isIndex()) {
            tocItem.setPageTitleIfNoTocOverridePresent("");
        }
    }

    private void updateSearchEntries(TocItem tocItem, MarkupParserResult parserResult) {
        List<GlobalSearchEntry> siteSearchEntries = parserResult.searchEntries().stream().map(pageSearchEntry -> new GlobalSearchEntry(this.searchEntryUrl(tocItem, (PageSearchEntry)pageSearchEntry), this.searchEntryTitle(tocItem, (PageSearchEntry)pageSearchEntry), pageSearchEntry.extractText())).collect(Collectors.toList());
        this.globalSearchEntries.addAll(siteSearchEntries);
        this.localSearchEntries.add(new PageLocalSearchEntries(tocItem, parserResult.searchEntries()));
    }

    private String searchEntryUrl(TocItem tocItem, PageSearchEntry pageSearchEntry) {
        DocUrl docUrl = tocItem.isIndex() ? DocUrl.indexUrl() : new DocUrl(tocItem.getDirName(), tocItem.getFileNameWithoutExtension(), pageSearchEntry.getPageSectionId());
        return this.docStructure.createUrl(null, docUrl);
    }

    private String searchEntryTitle(TocItem tocItem, PageSearchEntry pageSearchEntry) {
        if (tocItem.isIndex()) {
            return this.docMeta.getTitle() + " " + (pageSearchEntry.getPageSectionTitle().isEmpty() ? this.docMeta.getType() : pageSearchEntry.getPageSectionTitle());
        }
        return this.docMeta.getTitle() + ": " + tocItem.getPageTitle() + ", " + pageSearchEntry.getPageSectionTitle() + " [" + tocItem.getChapterTitle() + "]";
    }

    private void updateFilesAssociation(TocItem tocItem, List<AuxiliaryFile> newAuxiliaryFiles) {
        newAuxiliaryFiles.forEach(af -> this.auxiliaryFilesRegistry.updateFileAssociations(tocItem, (AuxiliaryFile)af));
    }

    private MarkupPathWithError resolveTocItem(TocItem tocItem) {
        try {
            return new MarkupPathWithError(this.markupParsingConfiguration.fullPath(this.componentsRegistry, this.cfg.docRootPath, tocItem), null);
        }
        catch (UnresolvedResourceException e) {
            return new MarkupPathWithError(null, e);
        }
    }

    private void generatePages() {
        ProgressReporter.reportPhase("generating the rest of HTML pages");
        this.forEachPage(this::generatePage);
        this.buildJsonOfAllPages();
    }

    private void generateSearchIndex() {
        ProgressReporter.reportPhase("generating search index");
        String jsIndexScript = this.localSearchEntries.buildIndexScript();
        this.deployer.deploy(SEARCH_INDEX_FILE_NAME, jsIndexScript);
        String xmlExternalIndex = this.globalSearchEntries.toXml();
        this.deployer.deploy("search-entries.xml", xmlExternalIndex);
    }

    private void buildJsonOfAllPages() {
        List listOfMaps = this.pagePropsByTocItem.values().stream().map(DocPageReactProps::toMap).collect(Collectors.toList());
        String json = JsonUtils.serialize(listOfMaps);
        this.deployer.deploy("all-pages.json", json);
    }

    private HtmlPageAndPageProps generatePage(TocItem tocItem, Page page) {
        try {
            HtmlPageAndPageProps htmlAndProps = this.createHtmlPageAndProps(tocItem, page);
            this.pagePropsByTocItem.put(tocItem, htmlAndProps.props());
            this.extraJavaScriptsInFront.forEach(htmlAndProps.htmlPage()::addJavaScriptInFront);
            this.extraJavaScriptsInBack.forEach(htmlAndProps.htmlPage()::addJavaScript);
            String html = htmlAndProps.htmlPage().render(this.docMeta.getId());
            Path pagePath = tocItem.isIndex() ? Paths.get("index.html", new String[0]) : Paths.get(tocItem.getDirName(), new String[0]).resolve(tocItem.getFileNameWithoutExtension()).resolve("index.html");
            MarkupPathWithError markupPathWithError = this.resolveTocItem(tocItem);
            if (markupPathWithError.path() == null && tocItem.isIndex()) {
                this.deployer.deploy("auto-generated-index", pagePath, html);
            } else {
                Path originalPathForLogging = this.cfg.docRootPath.relativize(this.markupParsingConfiguration.fullPath(this.componentsRegistry, this.cfg.docRootPath, tocItem).toAbsolutePath());
                this.deployer.deploy(originalPathForLogging.toString(), pagePath, html);
            }
            return htmlAndProps;
        }
        catch (Exception e) {
            throw new RuntimeException("error during rendering of " + tocItem.getFileNameWithoutExtension() + ": " + e.getMessage(), e);
        }
    }

    private HtmlPageAndPageProps createHtmlPageAndProps(TocItem tocItem, Page page) {
        if (page == null && tocItem.isIndex()) {
            return this.createRedirectingToFirstTocItemHtmlPageAndProps();
        }
        return this.pageToHtmlPageConverter.convert(tocItem, page, this.createServerSideRenderer(tocItem));
    }

    private HtmlPageAndPageProps createRedirectingToFirstTocItemHtmlPageAndProps() {
        TocItem firstNonIndexPage = this.toc.firstNonIndexPage();
        if (firstNonIndexPage == null) {
            throw new IllegalStateException("no documentation pages found");
        }
        String url = firstNonIndexPage.getDirName() + "/" + firstNonIndexPage.getFileNameWithoutExtension();
        MarkupParserResult parserResult = this.markupParser.parse(Paths.get("index", new String[0]), ":include-redirect: " + url);
        Instant lastModifiedTime = Instant.ofEpochSecond(0L);
        Page page = new Page(parserResult.docElement(), lastModifiedTime, parserResult.pageMeta());
        return this.pageToHtmlPageConverter.convert(this.toc.getIndex(), page, this.createServerSideRenderer(firstNonIndexPage));
    }

    private RenderSupplier createServerSideRenderer(TocItem tocItem) {
        PageLocalSearchEntries pageSearchEntries = this.localSearchEntries.searchEntriesByTocItem(tocItem);
        return () -> ServerSideSimplifiedRenderer.renderPageTextContent(pageSearchEntries) + ServerSideSimplifiedRenderer.renderToc(this.toc, this.docMeta.getId());
    }

    private void deployAuxiliaryFiles() {
        ProgressReporter.reportPhase("deploying auxiliary files (e.g. images)");
        this.auxiliaryFilesRegistry.getAuxiliaryFilesForDeployment().forEach(this::deployAuxiliaryFile);
    }

    private void deployUploadFiles() {
        ProgressReporter.reportPhase("deploying files from upload.txt");
        Path uploadTxtPath = this.cfg.getDocRootPath().resolve(UPLOAD_FILE_NAME);
        if (!Files.exists(uploadTxtPath, new LinkOption[0])) {
            return;
        }
        String fileNames = FileUtils.fileTextContent(uploadTxtPath);
        String[] names = fileNames.split("\n");
        Arrays.stream(names).map(String::trim).forEach(uploadEntry -> {
            Path fullPathToUpload = this.resourceResolver.fullPath((String)uploadEntry);
            this.deployer.deployFile(fullPathToUpload, (String)uploadEntry);
        });
    }

    private void deployAuxiliaryFileIfOutdated(AuxiliaryFile auxiliaryFile) {
        Long savedLastModifiedTime = this.auxiliaryFilesLastUpdateTime.get(auxiliaryFile);
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(auxiliaryFile.getPath(), new LinkOption[0]);
            if (savedLastModifiedTime != null && savedLastModifiedTime.longValue() == lastModifiedTime.toMillis()) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployAuxiliaryFile(auxiliaryFile);
    }

    private void deployAuxiliaryFile(AuxiliaryFile auxiliaryFile) {
        try {
            this.deployer.deploy(auxiliaryFile.getDeployRelativePath(), Files.readAllBytes(auxiliaryFile.getPath()));
            FileTime lastModifiedTime = Files.getLastModifiedTime(auxiliaryFile.getPath(), new LinkOption[0]);
            this.auxiliaryFilesLastUpdateTime.put(auxiliaryFile, lastModifiedTime.toMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void deployPluginsStats() {
        ProgressReporter.reportPhase("deploying plugins statistics");
        this.deployer.deploy("plugin-stats.json", JsonUtils.serialize(Plugins.buildStatsMap()));
    }

    private void forEachPage(PageConsumer consumer) {
        this.toc.getTocItems().forEach(tocItem -> {
            Page page = this.pageByTocItem.get(tocItem);
            consumer.consume((TocItem)tocItem, page);
        });
    }

    private void validateCollectedLinks() {
        ProgressReporter.reportPhase("validating links");
        this.docStructure.validateCollectedLinks();
    }

    private Stream<String> findLookupLocations(Configuration cfg) {
        Stream<String> root = Stream.of(cfg.docRootPath.toString());
        if (cfg.fileWithLookupPaths == null) {
            return root;
        }
        Stream additionalLookupPathsStream = cfg.additionalLookupPaths != null ? cfg.additionalLookupPaths.stream() : Stream.empty();
        return Stream.concat(root, Stream.concat(additionalLookupPathsStream, this.readLocationsFromFile(cfg.fileWithLookupPaths)));
    }

    private void printLookupLocations(Stream<String> stream) {
        ProgressReporter.reportPhase("lookup locations:");
        stream.forEach(path -> ConsoleOutputs.out(new Object[]{"    ", Color.PURPLE, path}));
    }

    private void parseAndSetPluginGlobalParams() {
        if (!Files.exists(this.cfg.pluginParamsPath, new LinkOption[0])) {
            return;
        }
        ProgressReporter.reportPhase("reading plugin global parameters:");
        ConsoleOutputs.out(new Object[]{Color.BLUE, "path: ", Color.PURPLE, this.cfg.pluginParamsPath});
        Map<String, Map<String, ?>> globalPluginParams = this.readPluginParams(this.cfg.pluginParamsPath);
        this.pluginParamsFactory.setGlobalParams(globalPluginParams);
        this.printPluginDefaultParams(globalPluginParams);
    }

    private void printPluginDefaultParams(Map<String, Map<String, ?>> params) {
        for (Map.Entry<String, Map<String, ?>> pluginEntry : params.entrySet()) {
            String pluginId = pluginEntry.getKey();
            if (!Plugins.hasPlugin(pluginId)) {
                throw new IllegalArgumentException("no plugin found with id: " + pluginId);
            }
            Map<String, ?> pluginParams = pluginEntry.getValue();
            ArrayList<Serializable> messageParts = new ArrayList<Serializable>(Arrays.asList(new Serializable[]{Color.YELLOW, pluginId, ": "}));
            for (Map.Entry<String, ?> paramEntry : pluginParams.entrySet()) {
                messageParts.add((Serializable)((Object)Color.PURPLE));
                messageParts.add((Serializable)((Object)paramEntry.getKey()));
                messageParts.add((Serializable)((Object)":"));
                messageParts.add((Serializable)((Object)FontStyle.NORMAL));
                messageParts.add((Serializable)paramEntry.getValue());
                messageParts.add((Serializable)((Object)" "));
            }
            ConsoleOutputs.out(messageParts.toArray());
        }
    }

    private Map<String, Map<String, ?>> readPluginParams(Path pluginParamsPath) {
        if (!Files.exists(pluginParamsPath, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, ?>> pluginParams = JsonUtils.deserializeAsMap(FileUtils.fileTextContent(pluginParamsPath));
        for (Object params : pluginParams.values()) {
            if (params instanceof Map) continue;
            throw new IllegalArgumentException("expected plugin parameters to be an object, given: " + params.getClass().getSimpleName());
        }
        return pluginParams;
    }

    private Stream<String> readLocationsFromFile(String filesLookupFilePath) {
        Path lookupFilePath = this.cfg.docRootPath.resolve(filesLookupFilePath);
        if (!Files.exists(lookupFilePath, new LinkOption[0])) {
            return Stream.empty();
        }
        String fileContent = FileUtils.fileTextContent(lookupFilePath);
        return Arrays.stream(fileContent.split("[;\n]")).map(String::trim).filter(e -> !e.isEmpty());
    }

    @Override
    public void phase(String message) {
        ProgressReporter.reportPhase(message);
    }

    @Override
    public void info(Object ... styleOrValue) {
        ConsoleOutputs.out(styleOrValue);
    }

    @Override
    public void warn(Object ... styleOrValue) {
        ConsoleOutputs.out(Stream.concat(Stream.of(new Serializable[]{Color.YELLOW, "[Warning] ", FontStyle.NORMAL}), Arrays.stream(styleOrValue)).toArray());
    }

    public void registerTocChangeListener(TocChangeListener listener) {
        this.tocChangeListeners.add(listener);
    }

    public void unregisterTocChangeListener(TocChangeListener listener) {
        this.tocChangeListeners.remove(listener);
    }

    public static class Configuration {
        private Path deployPath;
        private Path docRootPath;
        private Path footerPath;
        private Path extensionsDefPath;
        private Path globalReferencesPathNoExt;
        private Path pluginParamsPath;
        private final List<WebResource> webResources;
        private String id;
        private String title;
        private String type;
        private String fileWithLookupPaths;
        private final List<WebResource> registeredExtraJavaScripts;
        private boolean isPreviewEnabled;
        private boolean isValidateExternalLinks;
        private String documentationType = "markdown";
        private DocMeta docMeta = new DocMeta(Collections.emptyMap());
        private PageModifiedTimeStrategy pageModifiedTimeStrategy;
        private List<String> additionalLookupPaths;

        private Configuration() {
            this.webResources = new ArrayList<WebResource>();
            this.registeredExtraJavaScripts = new ArrayList<WebResource>();
        }

        public Configuration withDocumentationType(String documentationType) {
            this.documentationType = documentationType;
            return this;
        }

        public Configuration withRootPath(Path path) {
            this.docRootPath = path.toAbsolutePath();
            return this;
        }

        public Configuration withFooterPath(Path path) {
            this.footerPath = path.toAbsolutePath();
            return this;
        }

        public Configuration withExtensionsDefPath(Path path) {
            this.extensionsDefPath = path.toAbsolutePath();
            return this;
        }

        public Configuration withGlobalReferencesPathNoExt(Path path) {
            this.globalReferencesPathNoExt = path.toAbsolutePath();
            return this;
        }

        public Configuration withGlobalPluginParamsPath(Path path) {
            this.pluginParamsPath = path.toAbsolutePath();
            return this;
        }

        public Configuration withWebResources(WebResource ... resources) {
            this.webResources.addAll(Arrays.asList(resources));
            return this;
        }

        public Configuration withExtraJavaScripts(WebResource ... webResources) {
            this.registeredExtraJavaScripts.addAll(Arrays.asList(webResources));
            return this;
        }

        public Configuration withPageModifiedTimeStrategy(PageModifiedTimeStrategy modifiedTimeStrategy) {
            this.pageModifiedTimeStrategy = modifiedTimeStrategy;
            return this;
        }

        public Configuration withId(String id) {
            this.id = id;
            return this;
        }

        public Configuration withTitle(String title) {
            this.title = title;
            return this;
        }

        public Configuration withType(String type) {
            this.type = type;
            return this;
        }

        public Configuration withFileWithLookupPaths(String fileWithLookupPaths) {
            this.fileWithLookupPaths = fileWithLookupPaths;
            return this;
        }

        public Configuration withAdditionalLookupPaths(List<String> additionalLookupPaths) {
            this.additionalLookupPaths = additionalLookupPaths;
            return this;
        }

        public Configuration withMetaFromJsonFile(Path path) {
            String json = FileUtils.fileTextContent(path);
            this.docMeta = new DocMeta(json);
            this.withTitle(this.docMeta.getTitle());
            this.withType(this.docMeta.getType());
            return this;
        }

        public Configuration withEnabledPreview(boolean isPreviewEnabled) {
            this.isPreviewEnabled = isPreviewEnabled;
            return this;
        }

        public Configuration withValidateExternalLinks(boolean isValidateExternalLinks) {
            this.isValidateExternalLinks = isValidateExternalLinks;
            return this;
        }

        public Path getGlobalReferencesPathNoExt() {
            return this.globalReferencesPathNoExt;
        }

        public Path getDocRootPath() {
            return this.docRootPath;
        }

        public Path getFooterPath() {
            return this.footerPath;
        }

        public WebSite deployTo(Path path) {
            WebSite webSite = this.createWebSiteInstance(path);
            webSite.parseAndDeploy();
            return webSite;
        }

        public WebSite parseOnly() {
            WebSite webSite = this.createWebSiteInstance(Paths.get("", new String[0]));
            webSite.parse();
            return webSite;
        }

        private WebSite createWebSiteInstance(Path path) {
            this.deployPath = path.toAbsolutePath();
            return new WebSite(this);
        }
    }

    private static interface PageConsumer {
        public void consume(TocItem var1, Page var2);
    }
}

