/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv3;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JsonNumEquivalence;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Equivalence;
import znaishaded.com.google.common.collect.Sets;

public final class DraftV3TypeKeywordSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String ANY = "any";
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();

    public DraftV3TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isTextual()) {
            String found = node.textValue();
            if (!DraftV3TypeKeywordSyntaxChecker.typeIsValid(found)) {
                report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").putArgument("found", found).putArgument("valid", EnumSet.allOf(NodeType.class)));
            }
            return;
        }
        int size = node.size();
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueItems = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueItems = set.add(EQUIVALENCE.wrap(element));
            if (type == NodeType.OBJECT) {
                pointers.add(JsonPointer.of(this.keyword, index));
                continue;
            }
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.OBJECT, NodeType.STRING)).putArgument("found", type));
                continue;
            }
            if (DraftV3TypeKeywordSyntaxChecker.typeIsValid(element.textValue())) continue;
            report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").put("index", index).putArgument("found", element.textValue()).putArgument("valid", EnumSet.allOf(NodeType.class)));
        }
        if (!uniqueItems) {
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
        }
    }

    private static boolean typeIsValid(String s2) {
        return ANY.equals(s2) || NodeType.fromName(s2) != null;
    }
}

