/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.format.draftv3;

import java.math.BigInteger;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import znaishaded.com.github.fge.jsonschema.format.FormatAttribute;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class UTCMillisecAttribute
extends AbstractFormatAttribute {
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");
    private static final FormatAttribute INSTANCE = new UTCMillisecAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private UTCMillisecAttribute() {
        super("utc-millisec", NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        BigInteger epoch = instance.bigIntegerValue();
        if (epoch.signum() == -1) {
            report.warn(this.newMsg(data, bundle, "warn.format.epoch.negative").putArgument("value", instance));
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            report.warn(this.newMsg(data, bundle, "warn.format.epoch.overflow").putArgument("value", instance));
        }
    }
}

