/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.common;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.util.RegexECMA262Helper;
import znaishaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Joiner;
import znaishaded.com.google.common.collect.ImmutableSet;
import znaishaded.com.google.common.collect.Ordering;
import znaishaded.com.google.common.collect.Sets;

public final class AdditionalPropertiesValidator
extends AbstractKeywordValidator {
    private static final Joiner TOSTRING_JOINER = Joiner.on("; or ");
    private final boolean additionalOK;
    private final Set<String> properties;
    private final Set<String> patternProperties;

    public AdditionalPropertiesValidator(JsonNode digest) {
        super("additionalProperties");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode node : digest.get("properties")) {
            builder.add(node.textValue());
        }
        this.properties = builder.build();
        builder = ImmutableSet.builder();
        for (JsonNode node : digest.get("patternProperties")) {
            builder.add(node.textValue());
        }
        this.patternProperties = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        JsonNode instance = data.getInstance().getNode();
        HashSet<String> fields = Sets.newHashSet(instance.fieldNames());
        fields.removeAll(this.properties);
        HashSet<String> tmp = Sets.newHashSet();
        for (String field : fields) {
            for (String regex : this.patternProperties) {
                if (!RegexECMA262Helper.regMatch(regex, field)) continue;
                tmp.add(field);
            }
        }
        fields.removeAll(tmp);
        if (fields.isEmpty()) {
            return;
        }
        ArrayNode node = JacksonUtils.nodeFactory().arrayNode();
        for (String field : Ordering.natural().sortedCopy(fields)) {
            node.add(field);
        }
        report.error(this.newMsg(data, bundle, "err.common.additionalProperties.notAllowed").putArgument("unwanted", node));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword + ": ");
        if (this.additionalOK) {
            return sb.append("allowed").toString();
        }
        sb.append("none");
        if (this.properties.isEmpty() && this.patternProperties.isEmpty()) {
            return sb.toString();
        }
        sb.append(", unless: ");
        LinkedHashSet<String> further = Sets.newLinkedHashSet();
        if (!this.properties.isEmpty()) {
            further.add("one property is any of: " + this.properties);
        }
        if (!this.patternProperties.isEmpty()) {
            further.add("a property matches any regex among: " + this.patternProperties);
        }
        sb.append(TOSTRING_JOINER.join(further));
        return sb.toString();
    }
}

