/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.library;

import znaishaded.com.github.fge.Thawed;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.github.fge.jsonschema.keyword.digest.helpers.IdentityDigester;
import znaishaded.com.github.fge.jsonschema.keyword.digest.helpers.SimpleDigester;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import znaishaded.com.github.fge.jsonschema.keyword.validator.ReflectionKeywordValidatorFactory;
import znaishaded.com.github.fge.jsonschema.library.Keyword;
import znaishaded.com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;

public final class KeywordBuilder
implements Thawed<Keyword> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    final String name;
    SyntaxChecker syntaxChecker;
    Digester digester;
    KeywordValidatorFactory validatorFactory;

    KeywordBuilder(String name) {
        BUNDLE.checkNotNull(name, "nullName");
        this.name = name;
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.digester = keyword.digester;
        this.validatorFactory = keyword.validatorFactory;
    }

    public KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        BUNDLE.checkNotNullPrintf(syntaxChecker, "nullSyntaxChecker", this.name);
        this.syntaxChecker = syntaxChecker;
        return this;
    }

    public KeywordBuilder withDigester(Digester digester) {
        BUNDLE.checkNotNullPrintf(digester, "nullDigester", this.name);
        this.digester = digester;
        return this;
    }

    public KeywordBuilder withIdentityDigester(NodeType first, NodeType ... other) {
        this.digester = new IdentityDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withSimpleDigester(NodeType first, NodeType ... other) {
        this.digester = new SimpleDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> c) {
        this.validatorFactory = new ReflectionKeywordValidatorFactory(this.name, c);
        return this;
    }

    public KeywordBuilder withValidatorFactory(KeywordValidatorFactory factory) {
        this.validatorFactory = factory;
        return this;
    }

    @Override
    public Keyword freeze() {
        BUNDLE.checkArgumentPrintf(this.syntaxChecker != null, "noChecker", this.name);
        BUNDLE.checkArgumentPrintf(this.validatorFactory == null || this.digester != null, "malformedKeyword", this.name);
        return new Keyword(this);
    }

    private static NodeType checkType(NodeType type) {
        return BUNDLE.checkNotNull(type, "nullType");
    }

    private static NodeType[] checkTypes(NodeType ... types) {
        for (NodeType type : types) {
            BUNDLE.checkNotNull(type, "nullType");
        }
        return types;
    }
}

