/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.util;

import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.io.swagger.jackson.mixin.IgnoreOriginalRefMixin;
import znaishaded.io.swagger.jackson.mixin.OriginalRefMixin;
import znaishaded.io.swagger.models.RefModel;
import znaishaded.io.swagger.models.RefPath;
import znaishaded.io.swagger.models.RefResponse;
import znaishaded.io.swagger.models.parameters.RefParameter;
import znaishaded.io.swagger.models.properties.RefProperty;
import znaishaded.io.swagger.util.Json;
import znaishaded.io.swagger.util.Yaml;

public abstract class ReferenceSerializationConfigurer {
    private static void serializeAs(Class<?> cls, ObjectMapper mapper) {
        mapper.addMixIn(RefModel.class, cls);
        mapper.addMixIn(RefProperty.class, cls);
        mapper.addMixIn(RefPath.class, cls);
        mapper.addMixIn(RefParameter.class, cls);
        mapper.addMixIn(RefResponse.class, cls);
    }

    public static void serializeAsOriginalRef() {
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, Json.mapper());
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, Yaml.mapper());
    }

    public static void serializeAsComputedRef() {
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, Json.mapper());
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, Yaml.mapper());
    }

    public static void serializeAsOriginalRef(ObjectMapper mapper) {
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, mapper);
    }

    public static void serializeAsComputedRef(ObjectMapper mapper) {
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, mapper);
    }
}

