/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public abstract class CommandMultilines<S extends Diagram>
implements Command<S> {
    private final Pattern2 starting;

    public CommandMultilines(String patternStart) {
        if (!patternStart.startsWith("^") || !patternStart.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart);
        }
        this.starting = MyPattern.cmpile(patternStart);
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.pattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher2 m1 = this.starting.matcher(lines.getFirst().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        m1 = MyPattern.cmpile(this.getPatternEnd()).matcher(lines.getLast().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification();
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification() {
        return CommandControl.OK;
    }

    protected final Pattern2 getStartingPattern() {
        return this.starting;
    }
}

