/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public abstract class CommandMultilines3<S extends Diagram>
implements Command<S> {
    private final IRegex starting;
    private final MultilinesStrategy strategy;
    private final Trim trimEnd;

    public CommandMultilines3(IRegex patternStart, MultilinesStrategy strategy, Trim trimEnd) {
        if (!patternStart.getPattern().startsWith("^") || !patternStart.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart.getPattern());
        }
        this.strategy = strategy;
        this.starting = patternStart;
        this.trimEnd = trimEnd;
    }

    public abstract RegexConcat getPatternEnd2();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd2().getPattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        StringLocated potentialLast;
        lines = lines.cleanList(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        StringLocated first = lines.getFirst();
        if (first == null) {
            return CommandControl.NOT_OK;
        }
        boolean result1 = this.starting.match(first.getTrimmed());
        if (!result1) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        if (this.trimEnd == Trim.NONE) {
            potentialLast = lines.getLast();
        } else if (this.trimEnd == Trim.BOTH) {
            potentialLast = lines.getLast().getTrimmed();
        } else {
            throw new IllegalStateException();
        }
        boolean m1 = this.getPatternEnd2().match(potentialLast);
        if (!m1) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification();
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) throws NoSuchColorException {
        lines = lines.cleanList(this.strategy);
        return this.executeNow(system, lines);
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2) throws NoSuchColorException;

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification() {
        return CommandControl.OK;
    }

    protected final IRegex getStartingPattern() {
        return this.starting;
    }
}

