/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole;

import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Bullet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.AtomTextUtils;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;

public class StripeStyle {
    private final StripeStyleType type;
    private final int order;
    private final char style;

    public StripeStyle(StripeStyleType type, int order, char style) {
        this.type = type;
        this.order = order;
        this.style = style;
    }

    public final StripeStyleType getType() {
        return this.type;
    }

    public Atom getHeader(FontConfiguration fontConfiguration, CreoleContext context) {
        if (this.type == StripeStyleType.LIST_WITHOUT_NUMBER) {
            return new Bullet(fontConfiguration, this.order);
        }
        if (this.type == StripeStyleType.LIST_WITH_NUMBER) {
            int localNumber = context.getLocalNumber(this.order);
            return AtomTextUtils.createListNumber(fontConfiguration, this.order, localNumber);
        }
        return null;
    }

    public final int getOrder() {
        return this.order;
    }

    public char getStyle() {
        return this.style;
    }
}

