/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorRuntimeException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleColorChange
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*?)\\</color\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*)$)");
    private final Pattern2 mypattern;

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleColorChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleColorChange(patternEol);
    }

    private CommandCreoleColorChange(Pattern2 pattern) {
        this.mypattern = pattern;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) throws NoSuchColorRuntimeException {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        String s2 = m3.group(2);
        try {
            HColor color = HColorSet.instance().getColor(s2);
            FontConfiguration fc2 = fc1.changeColor(color);
            stripe.setActualFontConfiguration(fc2);
        }
        catch (NoSuchColorException noSuchColorException) {
            // empty catch block
        }
        stripe.analyzeAndAdd(m3.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

