/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d.DriverLineG2d;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d.DriverRectangleG2d;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontStyle;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFontContext;
import znaishaded.net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;
import znaishaded.net.sourceforge.plantuml.text.StyledString;

public class DriverTextG2d
implements UDriver<UText, Graphics2D> {
    private final EnsureVisible visible;
    private final StringBounder stringBounder;

    public DriverTextG2d(EnsureVisible visible, StringBounder stringBounder) {
        this.visible = visible;
        this.stringBounder = stringBounder;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (fontConfiguration.getColor().isTransparent()) {
            return;
        }
        String text = shape.getText();
        List<StyledString> strings = StyledString.build(text);
        for (StyledString styledString : strings) {
            FontConfiguration fc = styledString.getStyle() == FontStyle.BOLD ? fontConfiguration.bold() : fontConfiguration;
            x += this.printSingleText(g2d, fc, styledString.getText(), x, y, mapper);
        }
    }

    private double printSingleText(Graphics2D g2d, FontConfiguration fontConfiguration, String text, double x, double y, ColorMapper mapper) {
        UFont font = fontConfiguration.getFont();
        HColor extended = fontConfiguration.getExtendedColor();
        XDimension2D dim = this.stringBounder.calculateDimension(font, text);
        double height = Math.max(10.0, dim.getHeight());
        double width = dim.getWidth();
        boolean orientation = false;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            Rectangle2D.Double area = new Rectangle2D.Double(x, y - height + 1.5, width, height);
            if (extended instanceof HColorGradient) {
                GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, width, height, extended);
                g2d.setPaint(paint);
                g2d.fill(area);
            } else {
                Color backColor = extended.toColor(mapper);
                if (backColor != null) {
                    g2d.setColor(backColor);
                    g2d.setBackground(backColor);
                    g2d.fill(area);
                }
            }
        }
        this.visible.ensureVisible(x, y - height + 1.5);
        this.visible.ensureVisible(x + width, y + 1.5);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setFont(font.getUnderlayingFont(UFontContext.G2D));
        g2d.setColor(fontConfiguration.getColor().toColor(mapper));
        g2d.drawString(text, (float)x, (float)y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            UStroke stroke;
            if (extended != null) {
                g2d.setColor(extended.toColor(mapper));
            }
            if ((stroke = fontConfiguration.getUnderlineStroke()).getThickness() > 0.0) {
                DriverLineG2d.manageStroke(stroke, g2d);
                int ypos = (int)(y + 2.5);
                g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
                g2d.setStroke(new BasicStroke());
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            int ypos = (int)(y + 2.5) - 1;
            if (extended != null) {
                g2d.setColor(extended.toColor(mapper));
            }
            int i = (int)x;
            while ((double)i < x + width - 5.0) {
                g2d.drawLine(i, ypos - 0, i + 3, ypos + 1);
                g2d.drawLine(i + 3, ypos + 1, i + 6, ypos - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            FontMetrics fm = g2d.getFontMetrics(font.getUnderlayingFont(UFontContext.G2D));
            int ypos = (int)(y - (double)fm.getDescent() - 0.5);
            if (extended != null) {
                g2d.setColor(extended.toColor(mapper));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
        return width;
    }
}

