/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.AbstractShadowable;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionMode;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class UPolygon
extends AbstractShadowable {
    private final List<XPoint2D> all = new ArrayList<XPoint2D>();
    private final String name;
    private MinMax minmax = MinMax.getEmpty(false);
    private CompressionMode compressionMode;

    public UPolygon() {
        this((String)null);
    }

    public UPolygon(List<XPoint2D> points) {
        this((String)null);
        this.all.addAll(points);
        for (XPoint2D pt : this.all) {
            this.manageMinMax(pt.getX(), pt.getY());
        }
    }

    public UPolygon(String name) {
        this.name = name;
    }

    public XPoint2D getPoint(int idx) {
        return this.all.get(idx);
    }

    public XPoint2D checkMiddleContactForSpecificTriangle(XPoint2D center) {
        for (int i = 0; i < this.all.size() - 1; ++i) {
            XPoint2D pt1 = this.all.get(i);
            XPoint2D pt2 = this.all.get(i + 1);
            XPoint2D middle = new XPoint2D((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0);
            double delta = middle.distance(center);
            if (!(delta < 1.0)) continue;
            return this.all.get((i + this.all.size() - 1) % this.all.size());
        }
        return null;
    }

    public void addPoint(double x, double y) {
        this.all.add(new XPoint2D(x, y));
        this.manageMinMax(x, y);
    }

    public void addPoint(XPoint2D point) {
        this.addPoint(point.getX(), point.getY());
    }

    private void manageMinMax(double x, double y) {
        this.minmax = this.minmax.addPoint(x, y);
    }

    public List<XPoint2D> getPoints() {
        return this.all;
    }

    public UPolygon translate(double dx, double dy) {
        UPolygon result = new UPolygon();
        for (XPoint2D pt : this.all) {
            result.addPoint(pt.x + dx, pt.y + dy);
        }
        return result;
    }

    public void rotate(double theta) {
        if (theta == 0.0) {
            return;
        }
        this.affine(AffineTransform.getRotateInstance(theta));
    }

    public void affine(AffineTransform rotate) {
        for (int i = 0; i < this.all.size(); ++i) {
            this.all.set(i, this.all.get(i).transform(rotate));
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString() + " " + this.all;
    }

    public double getHeight() {
        return this.minmax.getHeight();
    }

    public double getWidth() {
        return this.minmax.getWidth();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public MinMax getMinMax() {
        return this.minmax;
    }

    public double[] getPointArray(double x, double y) {
        double[] points = new double[this.getPoints().size() * 2];
        int i = 0;
        for (XPoint2D pt : this.getPoints()) {
            points[i++] = pt.getX() + x;
            points[i++] = pt.getY() + y;
        }
        return points;
    }

    public final CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public final void setCompressionMode(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }
}

