/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.oregon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.oregon.Keyboard;
import znaishaded.net.sourceforge.plantuml.oregon.NoInputException;
import znaishaded.net.sourceforge.plantuml.oregon.Screen;

public class SmartKeyboard {
    private final Keyboard keyboard;
    private final List<String> history = new ArrayList<String>();

    public SmartKeyboard(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public String input(Screen screen) throws NoInputException {
        String s2 = this.keyboard.input();
        this.history.add(s2);
        screen.print("<i>? " + s2);
        return s2;
    }

    public int inputInt(Screen screen) throws NoInputException {
        String s2 = this.input(screen);
        if (!s2.matches("\\d+")) {
            screen.print("Please enter a valid number instead of " + s2);
            throw new NoInputException();
        }
        return Integer.parseInt(s2);
    }

    public boolean hasMore() {
        return this.keyboard.hasMore();
    }

    public List<String> getHistory() {
        return Collections.unmodifiableList(this.history);
    }
}

