/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.statediagram.command;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.statediagram.StateDiagram;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotag;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreateState() {
        super(CommandCreateState.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateState.class.getName(), RegexLeaf.start(), new RegexLeaf("state"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([%pLN_.]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]")), new RegexConcat(new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+)")), new RegexLeaf("CODE3", "([%pLN_.]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandCreateState.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LINECOLOR", "##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ADDFIELD", "(.*)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        HColor lineColor;
        String urlString;
        String stereotype;
        LeafType type;
        String idShort = arg.getLazzy("CODE", 0);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(idShort));
        String display = arg.getLazzy("DISPLAY", 0);
        if (display == null) {
            display = quark.getName();
        }
        if ((type = this.getTypeFromStereotype(stereotype = arg.get("STEREOTYPE", 0))) == null) {
            type = LeafType.STATE;
        }
        if (!diagram.checkConcurrentStateOk(quark)) {
            return CommandExecutionResult.error("The state " + quark.getName() + " has been created in a concurrent state : it cannot be used here.");
        }
        Entity ent = quark.getData();
        if (ent == null) {
            ent = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(display), type, null);
        }
        ent.setDisplay(Display.getWithNewlines(display));
        if (stereotype != null) {
            ent.setStereotype(Stereotype.build(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            ent.addUrl(url);
        }
        Colors colors = CommandCreateState.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = arg.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (arg.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(arg.get("LINECOLOR", 0));
        }
        ent.setColors(colors);
        String addFields = arg.get("ADDFIELD", 0);
        if (addFields != null) {
            ent.getBodier().addFieldOrMethod(addFields);
        }
        CommandCreateClassMultilines.addTags(ent, arg.getLazzy("TAGS", 0));
        return CommandExecutionResult.ok();
    }

    private LeafType getTypeFromStereotype(String stereotype) {
        if ("<<choice>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_CHOICE;
        }
        if ("<<fork>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<join>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<start>>".equalsIgnoreCase(stereotype)) {
            return LeafType.CIRCLE_START;
        }
        if ("<<end>>".equalsIgnoreCase(stereotype)) {
            return LeafType.CIRCLE_END;
        }
        if ("<<history>>".equalsIgnoreCase(stereotype)) {
            return LeafType.PSEUDO_STATE;
        }
        if ("<<history*>>".equalsIgnoreCase(stereotype)) {
            return LeafType.DEEP_HISTORY;
        }
        return null;
    }
}

