/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.Rankdir;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;

public class EntityImageSynchroBar
extends AbstractEntityImage {
    public EntityImageSynchroBar(Entity entity, ISkinParam skinParam, SName styleName) {
        super(entity, skinParam);
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activityBar);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.getSkinParam().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            return new XDimension2D(8.0, 80.0);
        }
        return new XDimension2D(80.0, 8.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        URectangle rect = URectangle.build(dim.getWidth(), dim.getHeight());
        Style style = this.getStyleSignature().withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor color = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        rect.setDeltaShadow(shadowing);
        ug.apply(HColors.none()).apply(color.bg()).draw(rect);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

