/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.util.Map;
import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageNote;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.utils.Direction;
import znaishaded.net.sourceforge.plantuml.utils.Position;

public class EntityImageTips
extends AbstractEntityImage {
    private final ISkinParam skinParam;
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final Bibliotekon bibliotekon;
    private final Style style;
    private final double ySpacing = 10.0;

    public EntityImageTips(Entity entity, ISkinParam skinParam, Bibliotekon bibliotekon, UmlDiagramType type) {
        super(entity, EntityImageNote.getSkin(skinParam, entity));
        this.skinParam = skinParam;
        this.bibliotekon = bibliotekon;
        this.style = this.getDefaultStyleDefinition(type.getStyleName()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
        this.borderColor = this.style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
    }

    private StyleSignature getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note).withTOBECHANGED(this.getStereo());
    }

    private Position getPosition() {
        if (this.getEntity().getName().endsWith(Position.RIGHT.name())) {
            return Position.RIGHT;
        }
        return Position.LEFT;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            XDimension2D dim = this.getOpale(display).calculateDimension(stringBounder);
            height += dim.getHeight();
            height += 10.0;
            width = Math.max(width, dim.getWidth());
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Entity tmp = this.getEntity();
        Entity other = this.bibliotekon.getOnlyOther(tmp);
        if (other == null) {
            System.err.println("Error1 in EntityImageTips");
            return;
        }
        SvekNode nodeMe = this.bibliotekon.getNode(this.getEntity());
        SvekNode nodeOther = this.bibliotekon.getNode(other);
        if (nodeOther == null) {
            System.err.println("Error2 in EntityImageTips");
            return;
        }
        XPoint2D positionOther = nodeOther.getPosition();
        this.bibliotekon.getNode(this.getEntity());
        Position position = this.getPosition();
        Direction direction = position.reverseDirection();
        XPoint2D positionMe = nodeMe.getPosition();
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            XRectangle2D memberPosition = nodeOther.getImage().getInnerPosition(ent.getKey(), stringBounder, InnerStrategy.STRICT);
            if (memberPosition == null) {
                return;
            }
            Opale opale = this.getOpale(display);
            XDimension2D dim = opale.calculateDimension(stringBounder);
            XPoint2D pp1 = new XPoint2D(0.0, dim.getHeight() / 2.0);
            double x = positionOther.getX() - positionMe.getX();
            if (direction == Direction.RIGHT && x < 0.0) {
                direction = direction.getInv();
            }
            x = direction == Direction.LEFT ? (x += memberPosition.getMaxX()) : (x += 4.0);
            double y = positionOther.getY() - positionMe.getY() - height + memberPosition.getCenterY();
            XPoint2D pp2 = new XPoint2D(x, y);
            opale.setOpale(direction, pp1, pp2);
            opale.drawU(ug);
            ug = ug.apply(UTranslate.dy(dim.getHeight() + 10.0));
            height += dim.getHeight();
            height += 10.0;
        }
    }

    private Opale getOpale(Display display) {
        double shadowing = this.style.value(PName.Shadowing).asDouble();
        FontConfiguration fc = this.style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        UStroke stroke = this.style.getStroke();
        TextBlock textBlock = BodyFactory.create3(display, this.skinParam, HorizontalAlignment.LEFT, fc, this.style.wrapWidth(), this.style);
        return new Opale(shadowing, this.borderColor, this.noteBackgroundColor, textBlock, true, stroke);
    }
}

