/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.footnotes;

import java.util.Set;
import znaishaded.org.commonmark.Extension;
import znaishaded.org.commonmark.ext.footnotes.internal.FootnoteBlockParser;
import znaishaded.org.commonmark.ext.footnotes.internal.FootnoteHtmlNodeRenderer;
import znaishaded.org.commonmark.ext.footnotes.internal.FootnoteLinkProcessor;
import znaishaded.org.commonmark.ext.footnotes.internal.FootnoteMarkdownNodeRenderer;
import znaishaded.org.commonmark.parser.Parser;
import znaishaded.org.commonmark.renderer.NodeRenderer;
import znaishaded.org.commonmark.renderer.html.HtmlRenderer;
import znaishaded.org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import znaishaded.org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import znaishaded.org.commonmark.renderer.markdown.MarkdownRenderer;

public class FootnotesExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
MarkdownRenderer.MarkdownRendererExtension {
    private final boolean inlineFootnotes;

    private FootnotesExtension(boolean inlineFootnotes) {
        this.inlineFootnotes = inlineFootnotes;
    }

    public static Extension create() {
        return FootnotesExtension.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customBlockParserFactory(new FootnoteBlockParser.Factory()).linkProcessor(new FootnoteLinkProcessor());
        if (this.inlineFootnotes) {
            parserBuilder.linkMarker(Character.valueOf('^'));
        }
    }

    @Override
    public void extend(HtmlRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(FootnoteHtmlNodeRenderer::new);
    }

    @Override
    public void extend(MarkdownRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(new MarkdownNodeRendererFactory(){

            @Override
            public NodeRenderer create(MarkdownNodeRendererContext context) {
                return new FootnoteMarkdownNodeRenderer(context);
            }

            @Override
            public Set<Character> getSpecialCharacters() {
                return Set.of();
            }
        });
    }

    public static class Builder {
        private boolean inlineFootnotes = false;

        public Builder inlineFootnotes(boolean inlineFootnotes) {
            this.inlineFootnotes = inlineFootnotes;
            return this;
        }

        public FootnotesExtension build() {
            return new FootnotesExtension(this.inlineFootnotes);
        }
    }
}

