/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;

public class PluginParams {
    private static final String RIGHT_SIDE_OPT_NAME = "rightSide";
    private static final String STICKY_SLIDE_OPT_NAME = "stickySlide";
    private final String pluginId;
    private final String freeParam;
    private final PluginParamsOpts opts;
    public static final PluginParams EMPTY = new PluginParams("", "", Collections.emptyMap());

    PluginParams(String pluginId, String freeParam, Map<String, ?> opts) {
        this.pluginId = pluginId;
        this.freeParam = freeParam;
        this.opts = new PluginParamsOpts(pluginId, this.shortcutMetaOptions(opts));
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getFreeParam() {
        return this.freeParam;
    }

    public PluginParamsOpts getOpts() {
        return this.opts;
    }

    private Map<String, ?> shortcutMetaOptions(Map<String, ?> opts) {
        LinkedHashMap result = new LinkedHashMap(opts);
        Object rightSide = opts.get(RIGHT_SIDE_OPT_NAME);
        Object stickySlide = opts.get(STICKY_SLIDE_OPT_NAME);
        if (rightSide == null && stickySlide == null) {
            return result;
        }
        if (this.pluginId.equals("meta")) {
            return result;
        }
        LinkedHashMap meta = new LinkedHashMap();
        if (rightSide != null) {
            meta.put(RIGHT_SIDE_OPT_NAME, rightSide);
        }
        if (stickySlide != null) {
            meta.put(STICKY_SLIDE_OPT_NAME, stickySlide);
        }
        result.put("meta", meta);
        result.remove(RIGHT_SIDE_OPT_NAME);
        result.remove(STICKY_SLIDE_OPT_NAME);
        return result;
    }
}

