/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.website.WebResource;
import znaishaded.org.apache.commons.io.FileUtils;

public record Deployer(Path docRoot, Path deployRoot) {
    public Deployer(Path docRoot, Path deployRoot) {
        this.docRoot = docRoot.toAbsolutePath().normalize();
        this.deployRoot = deployRoot.toAbsolutePath().normalize();
    }

    public void deploy(String relativePath, String content) {
        this.deploy(Paths.get(relativePath, new String[0]), content);
    }

    public void deploy(Path relativePath, String content) {
        this.deploy(relativePath.toString(), relativePath, content);
    }

    public void deploy(String originalPathForLogging, Path relativePath, String content) {
        this.deploy(originalPathForLogging, relativePath, content.getBytes(StandardCharsets.UTF_8));
    }

    public void deployFile(Path fullSrcPath, String relativePath) {
        Path deployPath = this.deployRoot.resolve(relativePath);
        this.printDeployMessage(relativePath, deployPath);
        if (!Files.exists(fullSrcPath, new LinkOption[0])) {
            throw new IllegalArgumentException("can't find file or directory: " + String.valueOf(fullSrcPath));
        }
        try {
            if (Files.isDirectory(fullSrcPath, new LinkOption[0])) {
                FileUtils.copyDirectory(fullSrcPath.toFile(), deployPath.toFile());
            } else {
                FileUtils.copyFile(fullSrcPath.toFile(), deployPath.toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deploy(WebResource webResource) {
        this.deploy(Paths.get(webResource.getPath(), new String[0]), webResource.getBinaryContent());
    }

    public void deploy(WebResource webResource, String content) {
        this.deploy(Paths.get(webResource.getPath(), new String[0]), content);
    }

    public void deploy(Path relativePath, byte[] content) {
        this.deploy(relativePath.toString(), relativePath, content);
    }

    public void deploy(String originalPathForLogging, Path relativePath, byte[] content) {
        Path fullPath = this.deployRoot.resolve(relativePath);
        this.printDeployMessage(originalPathForLogging, fullPath);
        try {
            Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            Files.write(fullPath, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printDeployMessage(Object from, Object to) {
        ConsoleOutputs.out(new Object[]{"deploying ", Color.PURPLE, from, Color.BLACK, " to ", Color.PURPLE, to});
    }
}

