/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonUtils;
import org.testingisdocumenting.znai.structure.DocStructure;

public class PythonType {
    private final String name;
    private final List<PythonType> types;
    private final PythonContext context;

    public PythonType(Object parsed, PythonContext context) {
        this.context = context;
        if (parsed instanceof Map) {
            Map map = (Map)parsed;
            this.name = this.nameWithAppliedDefault(map.get("name").toString());
            this.types = this.extractTypes(map);
        } else if (parsed != null) {
            this.name = this.nameWithAppliedDefault(parsed.toString());
            this.types = Collections.emptyList();
        } else {
            this.name = "";
            this.types = Collections.emptyList();
        }
    }

    public boolean isDefined() {
        return !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public List<PythonType> getTypes() {
        return this.types;
    }

    public String renderTypeAsString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        if (!this.types.isEmpty()) {
            result.append("[");
            result.append(this.types.stream().map(PythonType::renderTypeAsString).collect(Collectors.joining(", ")));
            result.append("]");
        }
        return result.toString();
    }

    public ApiLinkedText convertToApiLinkedText(DocStructure docStructure) {
        ApiLinkedText linkedText = new ApiLinkedText();
        if (this.name.isEmpty()) {
            return linkedText;
        }
        Supplier<String> typeUrlSupplier = () -> docStructure.findGlobalAnchorUrl(PythonUtils.globalAnchorId(this.name)).orElse("");
        linkedText.addPart(this.name, typeUrlSupplier);
        if (!this.types.isEmpty()) {
            linkedText.addPart("[");
            int idx = 0;
            for (PythonType type : this.types) {
                ApiLinkedText nested = type.convertToApiLinkedText(docStructure);
                linkedText.addParts(nested);
                if (idx < this.types.size() - 1) {
                    linkedText.addPart(", ");
                }
                ++idx;
            }
            linkedText.addPart("]");
        }
        return linkedText;
    }

    public String toString() {
        return "PythonCodeType{name='" + this.name + "', types=" + String.valueOf(this.types) + "}";
    }

    private String nameWithAppliedDefault(String name) {
        if (name.isEmpty()) {
            return name;
        }
        if (this.context.getDefaultPackageName().isEmpty()) {
            return name;
        }
        if (!name.contains(".") && this.context.isTypeDefined(name)) {
            return this.context.getDefaultPackageName() + "." + name;
        }
        return name;
    }

    private List<PythonType> extractTypes(Map<String, Object> map) {
        List list = (List)map.get("types");
        return list.stream().map(parsed -> new PythonType(parsed, this.context)).collect(Collectors.toList());
    }
}

