/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.utils.FileUtils;

public interface ResourcesResolver {
    public void initialize(Stream<String> var1);

    public boolean supportsLookupPath(String var1);

    public boolean canResolve(String var1);

    public List<String> listOfTriedLocations(String var1);

    default public String textContent(String path) {
        Path file = this.fullPath(path);
        return FileUtils.fileTextContent(file);
    }

    default public BufferedImage imageContent(String path) {
        Path fullPath = this.fullPath(path);
        try {
            return ImageIO.read(fullPath.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load image " + String.valueOf(fullPath), e);
        }
    }

    default public String textContent(Path path) {
        return this.textContent(path.toString());
    }

    public Path fullPath(String var1);

    public Path docRootRelativePath(Path var1);

    public boolean isInsideDoc(Path var1);

    public boolean isLocalFile(String var1);

    default public AuxiliaryFile runtimeAuxiliaryFile(String origin) {
        Path fullPath = this.fullPath(origin);
        Path docRelativePath = this.docRootRelativePath(fullPath);
        Path deployRelativePath = this.isInsideDoc(fullPath) ? docRelativePath : Paths.get(origin, new String[0]);
        return AuxiliaryFile.runTime(fullPath, deployRelativePath);
    }
}

