/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.search;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.structure.TocItem;

public record PageLocalSearchEntries(TocItem tocItem, List<PageSearchEntry> entries) {
    public List<List<String>> toListOfLists() {
        return this.entries.stream().map(this::createList).collect(Collectors.toList());
    }

    private String extractText(PageSearchEntry entry, SearchScore score) {
        return entry.getSearchTextList().stream().filter(e -> e.getScore() == score).map(SearchText::getText).collect(Collectors.joining(" "));
    }

    private List<String> createList(PageSearchEntry pageSearchEntry) {
        return Arrays.asList(this.genId(pageSearchEntry), this.tocItem.getChapterTitle(), this.tocItem.getPageTitle(), pageSearchEntry.getPageSectionTitle(), this.extractText(pageSearchEntry, SearchScore.STANDARD), this.extractText(pageSearchEntry, SearchScore.HIGH));
    }

    private String genId(PageSearchEntry pageSearchEntry) {
        return this.tocItem.getDirName() + "@@" + this.tocItem.getFileNameWithoutExtension() + "@@" + pageSearchEntry.getPageSectionId();
    }
}

