/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.structure.AnchorIds;

public class UniqueAnchorIdGenerator {
    private final Map<Path, List<LevelId>> headingsByPath = new ConcurrentHashMap<Path, List<LevelId>>();
    private final Map<Path, Map<String, Integer>> usedHeadingsCountByPath = new ConcurrentHashMap<Path, Map<String, Integer>>();

    public void registerSectionOrSubHeading(Path path, Integer level, String id) {
        List<LevelId> headings = this.getOrCreateHeadings(path);
        headings.removeIf(levelId -> levelId.level >= level);
        headings.add(new LevelId(level, id));
    }

    public AnchorIds generateIds(Path path, String nonUniqueId) {
        Prefixes prefixes = this.buildPrefixes(path, nonUniqueId);
        String main = this.updateWithCountSuffixIfRequired(path, prefixes.usingAllHeadings);
        String alternative = this.updateWithCountSuffixIfRequired(path, prefixes.usingLastHeading);
        boolean arePrefixesEqual = prefixes.usingAllHeadings.equals(prefixes.usingLastHeading);
        List<String> alternativeList = arePrefixesEqual ? Collections.emptyList() : Collections.singletonList(alternative);
        return new AnchorIds(main, alternativeList);
    }

    private String updateWithCountSuffixIfRequired(Path path, String prefix) {
        Map pathsCounts = this.usedHeadingsCountByPath.computeIfAbsent(path, k -> new HashMap());
        Integer count = pathsCounts.getOrDefault(prefix, 0);
        pathsCounts.put(prefix, count + 1);
        if (count == 0) {
            return prefix;
        }
        return prefix + "-" + (count + 1);
    }

    private Prefixes buildPrefixes(Path path, String nonUniqueId) {
        List<LevelId> headings = this.getOrCreateHeadings(path);
        String fullPrefix = headings.stream().map(LevelId::getId).filter(id -> !id.isEmpty()).collect(Collectors.joining("-"));
        String lastHeadingOnly = headings.isEmpty() ? "" : headings.get((int)(headings.size() - 1)).id;
        return new Prefixes(this.combinePrefixAndId(fullPrefix, nonUniqueId), this.combinePrefixAndId(lastHeadingOnly, nonUniqueId));
    }

    private String combinePrefixAndId(String prefix, String id) {
        if (prefix.isEmpty()) {
            return id;
        }
        if (id.isEmpty()) {
            return prefix;
        }
        return prefix + "-" + id;
    }

    private List<LevelId> getOrCreateHeadings(Path path) {
        return this.headingsByPath.computeIfAbsent(path, k -> new ArrayList());
    }

    public void resetCountersIfPresent(Path path) {
        this.headingsByPath.remove(path);
        this.usedHeadingsCountByPath.remove(path);
    }

    static class LevelId {
        private final Integer level;
        private final String id;

        public LevelId(Integer level, String id) {
            this.level = level;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    record Prefixes(String usingAllHeadings, String usingLastHeading) {
    }
}

