/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.common.collect;

import znaishaded.com.google.common.annotations.GwtCompatible;
import znaishaded.com.google.common.collect.AbstractMapBasedMultiset;
import znaishaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import znaishaded.com.google.common.collect.Iterables;
import znaishaded.com.google.common.collect.Multisets;
import znaishaded.com.google.common.collect.ObjectCountHashMap;
import znaishaded.com.google.common.collect.ObjectCountLinkedHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    public static <E> LinkedHashMultiset<E> create() {
        return LinkedHashMultiset.create(3);
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    LinkedHashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    ObjectCountHashMap<E> newBackingMap(int distinctElements) {
        return new ObjectCountLinkedHashMap(distinctElements);
    }
}

